/*
 * Decompiled with CFR 0.152.
 */
package com.oakmods.oaksbits.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ShutterNeighbourBlockChangesProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        BlockPos origin = BlockPos.containing((double)x, (double)y, (double)z);
        BlockState originState = world.getBlockState(origin);
        Property property = originState.getBlock().getStateDefinition().getProperty("open");
        if (!(property instanceof BooleanProperty)) {
            return;
        }
        BooleanProperty openProp = (BooleanProperty)property;
        boolean targetState = (Boolean)originState.getValue((Property)openProp);
        ShutterNeighbourBlockChangesProcedure.propagate(world, origin.above(), openProp, targetState, 1);
        ShutterNeighbourBlockChangesProcedure.propagate(world, origin.below(), openProp, targetState, -1);
    }

    private static void propagate(LevelAccessor world, BlockPos pos, BooleanProperty openProp, boolean targetState, int direction) {
        BooleanProperty prop;
        BlockState state;
        Property property;
        while ((property = (state = world.getBlockState(pos)).getBlock().getStateDefinition().getProperty("open")) instanceof BooleanProperty && (prop = (BooleanProperty)property) == openProp) {
            if ((Boolean)state.getValue((Property)openProp) != targetState) {
                world.setBlock(pos, (BlockState)state.setValue((Property)openProp, (Comparable)Boolean.valueOf(targetState)), 3);
            }
            pos = direction > 0 ? pos.above() : pos.below();
        }
    }
}

