/*
 * Decompiled with CFR 0.152.
 */
package com.oakmods.oaksbits.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ShuttersOnBlockRightClickedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, BlockState clickedState) {
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        if (!clickedState.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"oaksbits:shutters")))) {
            return;
        }
        Property property = clickedState.getBlock().getStateDefinition().getProperty("open");
        if (property instanceof BooleanProperty) {
            BooleanProperty openProp = (BooleanProperty)property;
            boolean newState = (Boolean)clickedState.getValue((Property)openProp) == false;
            world.setBlock(pos, (BlockState)clickedState.setValue((Property)openProp, (Comparable)Boolean.valueOf(newState)), 3);
            ShuttersOnBlockRightClickedProcedure.playSound(world, pos, clickedState, newState);
            ShuttersOnBlockRightClickedProcedure.propagateVertically(world, pos.above(), openProp, newState, 1);
            ShuttersOnBlockRightClickedProcedure.propagateVertically(world, pos.below(), openProp, newState, -1);
        }
    }

    private static void propagateVertically(LevelAccessor world, BlockPos startPos, BooleanProperty openProp, boolean targetState, int direction) {
        BooleanProperty prop;
        Property property;
        BlockState state;
        BlockPos pos = startPos;
        while ((state = world.getBlockState(pos)).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"oaksbits:shutters"))) && (property = state.getBlock().getStateDefinition().getProperty("open")) instanceof BooleanProperty && (prop = (BooleanProperty)property) == openProp) {
            if ((Boolean)state.getValue((Property)openProp) != targetState) {
                world.setBlock(pos, (BlockState)state.setValue((Property)openProp, (Comparable)Boolean.valueOf(targetState)), 3);
                ShuttersOnBlockRightClickedProcedure.playSound(world, pos, state, targetState);
            }
            pos = direction > 0 ? pos.above() : pos.below();
        }
    }

    private static void playSound(LevelAccessor world, BlockPos pos, BlockState state, boolean isOpen) {
        Level level;
        if (world instanceof Level && !(level = (Level)world).isClientSide()) {
            SoundType soundType = state.getSoundType();
            SoundEvent sound = soundType == SoundType.METAL ? (isOpen ? SoundEvents.IRON_TRAPDOOR_OPEN : SoundEvents.IRON_TRAPDOOR_CLOSE) : (isOpen ? SoundEvents.WOODEN_TRAPDOOR_OPEN : SoundEvents.WOODEN_TRAPDOOR_CLOSE);
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

