/*
 * Decompiled with CFR 0.152.
 */
package com.oakmods.oaksbits.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class ToolRackRendererProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ToolRackRendererProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        ToolRackRendererProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.getBlock();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            BlockEntity blockEntity = entityBlock.newBlockEntity(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                blockEntity.setLevel((Level)level);
                blockEntityRenderer.render(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
            ModelBlockRenderer renderer = dispatcher.getModelRenderer();
            BakedModel bakedModel = dispatcher.getBlockModel(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.last();
            int color = minecraft.getBlockColors().getColor(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.create((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.getBuffer(Sheets.translucentCullBlockSheet()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.NO_OVERLAY, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.level() != level) {
                entity = type.create((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.create((Level)level);
            data.put(type, entity);
        }
        ToolRackRendererProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick().getGameTimeDeltaPartialTick(false);
        int packedLight = glowing ? 0xF000F0 : Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(entity, partialTick);
        ToolRackRendererProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        EntityRenderer renderer = minecraft.getEntityRenderDispatcher().getRenderer(entity);
        Vec3 pos = provider.getCamera().getPosition();
        float offset = entity.getBbHeight() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y + (double)offset - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.translate(0.0f, -offset, 0.0f);
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.render(entity, entity.getViewYRot(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        ItemRenderer renderer = minecraft.getItemRenderer();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.renderStatic(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.level, packedLight, OverlayTexture.NO_OVERLAY, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).normalize().toVector3f();
        Matrix4f matrix4f = provider.getPoseStack().last().pose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        vertexConsumer.addVertex(matrix4f, (float)(x1 - pos.x()), (float)(y1 - pos.y()), (float)(z1 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
        vertexConsumer.addVertex(matrix4f, (float)(x2 - pos.x()), (float)(y2 - pos.y()), (float)(z2 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.getInstance().level;
            Entity entity = provider.getCamera().getEntity();
            Vec3 pos = entity.getPosition(provider.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            ToolRackRendererProcedure.execute((Event)provider, (LevelAccessor)level);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute(LevelAccessor world) {
        ToolRackRendererProcedure.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        double ItemRot = 0.0;
        double ItemScale = 0.0;
        double ItemY = 0.0;
        if (world instanceof ClientLevel) {
            ClientLevel _blockEntityContext = (ClientLevel)world;
            int _scanRange = Minecraft.getInstance().options.getEffectiveRenderDistance();
            BlockPos _scanCenter = Minecraft.getInstance().player.blockPosition();
            for (int _chunkZ = -_scanRange; _chunkZ <= _scanRange; ++_chunkZ) {
                for (int _chunkX = -_scanRange; _chunkX <= _scanRange; ++_chunkX) {
                    LevelChunk _levelChunk = _blockEntityContext.getChunk(SectionPos.blockToSectionCoord((int)(_scanCenter.getX() + (_chunkX << 4))), SectionPos.blockToSectionCoord((int)(_scanCenter.getZ() + (_chunkZ << 4))));
                    if (_levelChunk == null) continue;
                    for (Map.Entry _blockEntityEntry : _levelChunk.getBlockEntities().entrySet()) {
                        int positionz;
                        int positiony;
                        BlockState blockstateiterator = ((BlockEntity)_blockEntityEntry.getValue()).getBlockState();
                        int positionx = ((BlockPos)_blockEntityEntry.getKey()).getX();
                        if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony = ((BlockPos)_blockEntityEntry.getKey()).getY(), positionz = ((BlockPos)_blockEntityEntry.getKey()).getZ()), 0).copy().getItem() instanceof AxeItem) {
                            ItemRot = 45.0;
                            ItemY = 0.45;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() == Items.MACE) {
                            ItemRot = 45.0;
                            ItemY = 0.45;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() == Items.FISHING_ROD) {
                            ItemRot = -42.5;
                            ItemY = 0.5;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof ShovelItem) {
                            ItemRot = 45.0;
                            ItemY = 0.45;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof PickaxeItem) {
                            ItemRot = 45.0;
                            ItemY = 0.35;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof CrossbowItem) {
                            ItemRot = 45.0;
                            ItemY = 0.5;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof HoeItem) {
                            ItemRot = 45.0;
                            ItemY = 0.3;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof SwordItem) {
                            ItemY = 0.45;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof TridentItem) {
                            ItemRot = 45.0;
                            ItemY = 0.5;
                            ItemScale = 0.75;
                        } else if (ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy().getItem() instanceof ShieldItem) {
                            ItemRot = 0.0;
                            ItemScale = 1.75;
                            ItemY = 0.5;
                        } else {
                            ItemRot = -135.0;
                            ItemScale = 1.0;
                            ItemY = 0.2;
                        }
                        if (!blockstateiterator.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"oaksbits:tool_rack")))) continue;
                        if (ToolRackRendererProcedure.getDirectionFromBlockState(blockstateiterator) == Direction.NORTH) {
                            ToolRackRendererProcedure.renderItem(ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy(), (double)positionx + 0.5, (double)positiony + ItemY, (double)positionz + 0.9, 0.0f, 0.0f, (float)ItemRot, (float)ItemScale, false, false);
                            continue;
                        }
                        if (ToolRackRendererProcedure.getDirectionFromBlockState(blockstateiterator) == Direction.SOUTH) {
                            ToolRackRendererProcedure.renderItem(ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy(), (double)positionx + 0.5, (double)positiony + ItemY, (double)positionz + 0.1, 180.0f, 0.0f, (float)ItemRot, (float)ItemScale, false, false);
                            continue;
                        }
                        if (ToolRackRendererProcedure.getDirectionFromBlockState(blockstateiterator) == Direction.EAST) {
                            ToolRackRendererProcedure.renderItem(ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy(), (double)positionx + 0.1, (double)positiony + ItemY, (double)positionz + 0.5, 90.0f, 0.0f, (float)ItemRot, (float)ItemScale, false, false);
                            continue;
                        }
                        if (ToolRackRendererProcedure.getDirectionFromBlockState(blockstateiterator) != Direction.WEST) continue;
                        ToolRackRendererProcedure.renderItem(ToolRackRendererProcedure.itemFromBlockInventory(world, new BlockPos(positionx, positiony, positionz), 0).copy(), (double)positionx + 0.9, (double)positiony + ItemY, (double)positionz + 0.5, 270.0f, 0.0f, (float)ItemRot, (float)ItemScale, false, false);
                    }
                }
            }
        }
    }

    private static ItemStack itemFromBlockInventory(LevelAccessor world, BlockPos pos, int slot) {
        ILevelExtension ext;
        IItemHandler itemHandler;
        if (world instanceof ILevelExtension && (itemHandler = (IItemHandler)(ext = (ILevelExtension)world).getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    private static Direction getDirectionFromBlockState(BlockState blockState) {
        EnumProperty ep;
        Property prop = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (prop instanceof DirectionProperty) {
            DirectionProperty dp = (DirectionProperty)prop;
            return (Direction)blockState.getValue((Property)dp);
        }
        prop = blockState.getBlock().getStateDefinition().getProperty("axis");
        return prop instanceof EnumProperty && (ep = (EnumProperty)prop).getPossibleValues().toArray()[0] instanceof Direction.Axis ? Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : Direction.NORTH;
    }
}

