tag @s add find
# Note to .itemtype id:
# 0 = Unknown / Unforgeable
# 1 = Melee
# 2 = Ranged
# 3 = Armor - Head
# 4 = Armor - Chest
# 5 = Armor - Legs
# 6 = Armor - Feet
# 7 = Tools
# 8 = Utilities
# Note to .specialtype id:
# 0 = Unknown
# 1 = Gilded

# Find Player
execute as @a at @s run function reforge:find_players

# Score Init
scoreboard players set .itemtype id 0
scoreboard players set .item reforgeId -1
scoreboard players set .item_reforge reforgeId -1
scoreboard players set .specialtype id 0
scoreboard players set .specialtype_axe id 0
scoreboard players set .specialtype_hoe id 0
scoreboard players set .xp_matched const 0
scoreboard players set .item_mod const 0
scoreboard players set .enhancement_count const 0

execute as @e[tag=target_type_item] at @s if score @s id = @e[tag=find,limit=1] id run tag @s add targetforgeitem
execute as @e[tag=target_type_reforge] at @s if score @s id = @e[tag=find,limit=1] id run tag @s add targetforgemodifier

# Detect if the player have enough xp
execute as @p[tag=targetplayer] at @s run function reforge:forging/xp/detection
execute unless score .xp_matched const matches 1.. run tellraw @p[tag=targetplayer] [{"bold":true,"color":"white","italic":false,"text":"Forge: "},{"bold":true,"color":"red","italic":false,"text":"Not enough xp levels to forge the item!"}]
execute unless score .xp_matched const matches 1.. run execute as @n[tag=find] at @s run function reforge:forging/detection_reset
execute unless score .xp_matched const matches 1.. run return fail

# Effect
execute as @e[tag=targetforgeitem] at @s run particle smoke ~ ~ ~ 0.1 0.1 0.1 0.01 5 normal
execute as @e[tag=targetforgemodifier] at @s run particle smoke ~ ~ ~ 0.1 0.1 0.1 0.01 5 normal

# ----- Special Detections -----
# > 1. Gilded:
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isgolditem run scoreboard players set .specialtype id 1
# > 2. Axe:
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isaxe run scoreboard players set .specialtype_axe id 1
# > 3. Bow:
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isbow run scoreboard players set .specialtype id 3
# > 4. Elytra:
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:iselytra run scoreboard players set .specialtype id 4
# > 5. Hoe:
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:ishoe run scoreboard players set .specialtype_hoe id 1
# > 6. Heads:
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isheads run scoreboard players set .itemtype id 3

# Store item data to the reforge storage
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run data modify storage minecraft:reforge forge_itemid set from entity @s item.id
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run data modify storage minecraft:reforge forge_itemcomponents set from entity @s item.components
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute unless data entity @s item.components run data modify storage minecraft:reforge forge_itemcomponents set value {}
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run data modify storage minecraft:reforge forge.name set from entity @s item.components.minecraft:custom_data.itemname
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute unless data entity @s item.components.minecraft:custom_data.itemname run data modify storage minecraft:reforge forge.name set value ""
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] if data entity @s item.components.minecraft:custom_data.enhancement_count run execute store result score .enhancement_count const run data get entity @s item.components.minecraft:custom_data.enhancement_count
# Store reforge id from the forge item
execute as @e[tag=targetforgemodifier,sort=nearest,limit=1] at @s run execute store result score .item_reforge reforgeId run data get entity @s item.components.minecraft:custom_data.reforgeid
execute as @e[tag=targetforgemodifier,sort=nearest,limit=1] at @s unless data entity @s item.components.minecraft:custom_data.reforgeid run scoreboard players set .item_reforge reforgeId -1
execute as @e[tag=targetforgemodifier,sort=nearest,limit=1] at @s unless data entity @s item.components.minecraft:custom_data.reforgeid run data modify storage minecraft:item store.reforge_id set from entity @s item.components.minecraft:profile.properties[0].signature
execute as @e[tag=targetforgemodifier,sort=nearest,limit=1] at @s unless data entity @s item.components.minecraft:custom_data.reforgeid run function reforge:forging/get_id_from_signature with storage minecraft:item store
execute as @e[tag=targetforgemodifier,sort=nearest,limit=1] at @s run data modify storage minecraft:reforge forge.forgeid set from entity @s item.components.minecraft:custom_data.reforgeid
execute as @e[tag=targetforgemodifier,sort=nearest,limit=1] at @s run execute if data entity @s item.components.minecraft:custom_data.mod_type store result score .item_mod id run data get entity @s item.components.minecraft:custom_data.mod_type
# Store reforge id from the item
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute store result score .item reforgeId run data get entity @s item.components.minecraft:custom_data.reforgeid
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s unless data entity @s item.components.minecraft:custom_data.reforgeid run scoreboard players set .item reforgeId -1
# Store item type from the item
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:ismelee run scoreboard players set .itemtype id 1
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isranged run scoreboard players set .itemtype id 2
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:ishelmet run scoreboard players set .itemtype id 3
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:ischestplate run scoreboard players set .itemtype id 4
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isleggings run scoreboard players set .itemtype id 5
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isboots run scoreboard players set .itemtype id 6
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:istools run scoreboard players set .itemtype id 7
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if predicate reforge:isutilities run scoreboard players set .itemtype id 8
execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run execute if data entity @s item.components.minecraft:custom_data.typeid run execute store result score .itemtype id run data get entity @s item.components.minecraft:custom_data.typeid
execute if score .itemtype id matches 1..2 run data modify storage minecraft:reforge forge.slot set value "mainhand"
execute if score .itemtype id matches 7..9 run data modify storage minecraft:reforge forge.slot set value "mainhand"
execute if score .itemtype id matches 3 run data modify storage minecraft:reforge forge.slot set value "head"
execute if score .itemtype id matches 4 run data modify storage minecraft:reforge forge.slot set value "chest"
execute if score .itemtype id matches 5 run data modify storage minecraft:reforge forge.slot set value "legs"
execute if score .itemtype id matches 6 run data modify storage minecraft:reforge forge.slot set value "feet"

function reforge:forging/randomizeduuid
execute as @s if score .item reforgeId matches 0 if score .itemtype id matches 1.. unless score .item_reforge reforgeId matches 39 unless score .item_reforge reforgeId matches 75 if score .item_reforge reforgeId matches 1.. run function reforge:forging/forge_item
# Special Reforges
execute as @s if score .itemtype id matches 1.. if score .item_reforge reforgeId matches 39 run function reforge:forging/forge_item
execute as @s if score .item reforgeId matches 0.. if score .itemtype id matches 1.. if score .item_reforge reforgeId matches 75 run function reforge:forging/forge_item

execute as @s if score .item reforgeId matches -1 if score .item_reforge reforgeId matches 0 run execute as @e[tag=targetforgeitem,sort=nearest,limit=1] at @s run function reforge:forging/getvanilladata with storage minecraft:reforge uuid
execute as @s if score .item reforgeId matches -1 if score .item_reforge reforgeId matches 0 run function reforge:forging/vanilla_forge with storage minecraft:reforge vanilla 

execute as @s run function reforge:forging/detection_reset