/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import net.createmod.catnip.lang.FontHelper;
import net.dakotapride.creategarnished.entity.client.VoltfishRenderer;
import net.dakotapride.creategarnished.particle.CaramelParticle;
import net.dakotapride.creategarnished.particle.ElvenMysticalParticleType;
import net.dakotapride.creategarnished.recipe.CreateGarnishedRecipeSerializers;
import net.dakotapride.creategarnished.registry.CreateGarnishedBlocks;
import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedCreativeModeTabs;
import net.dakotapride.creategarnished.registry.CreateGarnishedEntityTypes;
import net.dakotapride.creategarnished.registry.CreateGarnishedFluids;
import net.dakotapride.creategarnished.registry.CreateGarnishedItems;
import net.dakotapride.creategarnished.registry.CreateGarnishedParticles;
import net.dakotapride.creategarnished.registry.CreateGarnishedPotions;
import net.dakotapride.creategarnished.registry.CreateGarnishedSounds;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatisics;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatusEffects;
import net.dakotapride.creategarnished.registry.CreateGarnishedTriggers;
import net.minecraft.client.particle.ExplodeParticle;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="creategarnished")
public class CreateGarnished {
    public static final String ID = "creategarnished";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"creategarnished").defaultCreativeTab((ResourceKey)null);

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public CreateGarnished(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        REGISTRATE.registerEventListeners(modEventBus);
        modEventBus.addListener(this::commonSetup);
        CreateGarnishedBlocks.register();
        CreateGarnishedItems.register();
        CreateGarnishedCreativeModeTabs.register(modEventBus);
        CreateGarnishedFluids.register();
        CreateGarnishedParticles.register(modEventBus);
        CreateGarnishedStatusEffects.register(modEventBus);
        CreateGarnishedPotions.register(modEventBus);
        CreateGarnishedEntityTypes.register(modEventBus);
        CreateGarnishedRecipeSerializers.register(modEventBus);
        CreateGarnishedTriggers.register(modEventBus);
        CreateGarnishedStatisics.STATS.register(modEventBus);
        CreateGarnishedConfigs.register(modLoadingContext, modContainer);
        CreateGarnishedSounds.register(modEventBus);
        modEventBus.addListener(CreateGarnished::enqueue);
        LOGGER.info("[WARNING] Create: Garnished Reworked EMI Compatibility is limited and may be incorrect depending on the config settings presented by the mod.");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CreateGarnishedFluids.registerFluidInteractions();
    }

    private static void enqueue(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Stats.CUSTOM.get((Object)((ResourceLocation)CreateGarnishedStatisics.HATCHET_KILLS.get()), StatFormatter.DEFAULT);
            Stats.CUSTOM.get((Object)((ResourceLocation)CreateGarnishedStatisics.MONSTER_HATCHET_KILLS.get()), StatFormatter.DEFAULT);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE));
    }

    @EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(CreateGarnishedEntityTypes.VOLTFISH.get(), VoltfishRenderer::new);
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)CreateGarnishedParticles.ELVEN_MYSTICAL_PARTICLE.get(), ElvenMysticalParticleType.Provider::new);
            event.registerSpriteSet((ParticleType)CreateGarnishedParticles.HATCHET_PARTICLE.get(), ExplodeParticle.Provider::new);
            event.registerSpriteSet((ParticleType)CreateGarnishedParticles.VOLT.get(), SpellParticle.Provider::new);
            event.registerSpriteSet((ParticleType)CreateGarnishedParticles.CARAMEL.get(), CaramelParticle.Provider::new);
        }

        @SubscribeEvent
        public static void onAddPackFinders(AddPackFindersEvent event) {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                // empty if block
            }
        }

        private static void registerBuiltinResourcePack(AddPackFindersEvent event, String folder, PackSource source, boolean alwaysActive) {
            event.addPackFinders(CreateGarnished.asResource("assets/creategarnished/resourcepacks/" + folder), PackType.CLIENT_RESOURCES, (Component)Component.literal((String)("creategarnished/" + folder)), source, alwaysActive, Pack.Position.TOP);
        }
    }

    @EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public static class ModEvents {
        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        }
    }
}

