/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.block;

import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BirchLogExtractingSapBlock
extends RotatedPillarBlock {
    public static final BooleanProperty HAS_SAP = BooleanProperty.create((String)"has_sap");

    public BirchLogExtractingSapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getSapProperty(), (Comparable)Boolean.valueOf(false)));
    }

    public BooleanProperty getSapProperty() {
        return HAS_SAP;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)this.getSapProperty()) == false;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource random) {
        int r = random.nextInt(2);
        if (r != 0 && BirchLogExtractingSapBlock.hasRequiredLogs(state, (LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_SAP, (Comparable)Boolean.valueOf(true)));
            super.randomTick(state, level, pos, random);
        }
    }

    public static boolean hasRequiredLogs(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)CreateGarnishedConfigs.server().block.requireLogsForSapGeneration.get()).booleanValue()) {
            return level.getBlockState(pos.above()).is(BlockTags.BIRCH_LOGS) && level.getBlockState(pos.below()).is(BlockTags.BIRCH_LOGS);
        }
        return (Boolean)CreateGarnishedConfigs.server().block.requireLogsForSapGeneration.get() == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_SAP});
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (stack.is(Items.GLASS_BOTTLE) && ((Boolean)state.getValue((Property)HAS_SAP)).booleanValue()) {
            stack.shrink(1);
            player.addItem(new ItemStack((ItemLike)CreateGarnishedItems.BIRCH_SAP_BOTTLE.get(), 1));
            if (((Boolean)CreateGarnishedConfigs.server().block.allowForRenewableBirchSap.get()).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_SAP, (Comparable)Boolean.valueOf(false)));
            } else {
                level.setBlock(pos, Blocks.BIRCH_LOG.defaultBlockState(), 11);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

