/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.block;

import com.mojang.serialization.MapCodec;
import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedDamageSources;
import net.dakotapride.creategarnished.registry.CreateGarnishedItems;
import net.dakotapride.creategarnished.registry.CreateGarnishedParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public class ElvenSweetBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<ElvenSweetBerryBushBlock> CODEC = ElvenSweetBerryBushBlock.simpleCodec(ElvenSweetBerryBushBlock::new);
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public ElvenSweetBerryBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)CreateGarnishedItems.ELVEN_SWEET_BERRIES.get());
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if ((Integer)pState.getValue((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)pState.getValue((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.getShape(pState, pLevel, pPos, pContext);
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = (Integer)pState.getValue((Property)AGE);
        if (i < 3 && pLevel.getRawBrightness(pPos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            pLevel.setBlock(pPos, blockstate, 2);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        VoxelShape voxelshape = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
        Vec3 vec3 = voxelshape.bounds().getCenter();
        int age = (Integer)state.getValue((Property)AGE);
        double d0 = (double)pos.getX() + vec3.x;
        double d1 = (double)pos.getZ() + vec3.z;
        if (((Boolean)CreateGarnishedConfigs.server().block.elvenSweetBerryBushParticles.get()).booleanValue()) {
            for (int i = 0; i < age; ++i) {
                if (!random.nextBoolean()) continue;
                level.addParticle((ParticleOptions)CreateGarnishedParticles.ELVEN_MYSTICAL_PARTICLE.get(), d0 + random.nextDouble() / 5.0, (double)pos.getY() + (0.5 - random.nextDouble()), d1 + random.nextDouble() / 5.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof LivingEntity && pEntity.getType() != EntityType.FOX && pEntity.getType() != EntityType.BEE) {
            pEntity.makeStuckInBlock(pState, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(pLevel.isClientSide || (Integer)pState.getValue((Property)AGE) <= 0 || pEntity.xOld == pEntity.getX() && pEntity.zOld == pEntity.getZ())) {
                double d0 = Math.abs(pEntity.getX() - pEntity.xOld);
                double d1 = Math.abs(pEntity.getZ() - pEntity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    pEntity.hurt(CreateGarnishedDamageSources.elvenSweetBerryBush(pLevel), ((Double)CreateGarnishedConfigs.server().entity.elvenSweetBerryBushPrickDamageAmount.get()).floatValue());
                }
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i = (Integer)state.getValue((Property)AGE);
        boolean flag = i == 3;
        return !flag && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (i > 1) {
            int j = 1 + level.random.nextInt(2);
            ElvenSweetBerryBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)CreateGarnishedItems.ELVEN_SWEET_BERRIES.get(), j + (flag ? 1 : 0)));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int i = Math.min(3, (Integer)pState.getValue((Property)AGE) + 1);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

