/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.block;

import com.mojang.serialization.MapCodec;
import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PoundCakeBlock
extends Block {
    public static final MapCodec<PoundCakeBlock> CODEC = PoundCakeBlock.simpleCodec(PoundCakeBlock::new);
    public static final int MAX_BITES = 6;
    public static final IntegerProperty BITES = BlockStateProperties.BITES;
    public static final int FULL_CAKE_SIGNAL = PoundCakeBlock.getOutputSignal(0);
    protected static final float AABB_OFFSET = 1.0f;
    protected static final float AABB_SIZE_PER_BITE = 2.0f;
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public MapCodec<PoundCakeBlock> codec() {
        return CODEC;
    }

    public PoundCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITE[(Integer)state.getValue((Property)BITES)];
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (PoundCakeBlock.eat((LevelAccessor)level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return PoundCakeBlock.eat((LevelAccessor)level, pos, state, player);
    }

    protected static InteractionResult eat(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(8, 0.8f);
        Holder biome = player.level().getBiome(player.blockPosition());
        boolean isInBiome = biome.is(CreateGarnishedTags.IS_ACCEPTED_FLOWER_BIOME);
        if (isInBiome && ((Boolean)CreateGarnishedConfigs.server().entity.provideSpecialEffectsFromBiome.get()).booleanValue()) {
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 2400, 1, false, false, false));
        }
        int i = (Integer)state.getValue((Property)BITES);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES});
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return PoundCakeBlock.getOutputSignal((Integer)blockState.getValue((Property)BITES));
    }

    public static int getOutputSignal(int eaten) {
        return (7 - eaten) * 2;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

