/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VoltfishEntity
extends AbstractFish {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public VoltfishEntity(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        super.registerGoals();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return AbstractFish.createAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY).add(Attributes.FOLLOW_RANGE, 240.0);
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.COD_FLOP;
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        return null;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    static class VoltfishMoveControl
    extends MoveControl {
        private final AbstractFish fish;

        VoltfishMoveControl(AbstractFish fish) {
            super((Mob)fish);
            this.fish = fish;
        }

        public void tick() {
            if (this.fish.isEyeInFluid(FluidTags.WATER)) {
                this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.fish.getNavigation().isDone()) {
                if (this.fish.isAggressive()) {
                    float f = (float)(this.speedModifier * this.fish.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    this.fish.setSpeed((float)((double)Mth.lerp((float)0.125f, (float)this.fish.getSpeed(), (float)f) * 1.5));
                    double d0 = this.wantedX - this.fish.getX();
                    double d1 = this.wantedY - this.fish.getY();
                    double d2 = this.wantedZ - this.fish.getZ();
                    if (d1 != 0.0) {
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(0.0, (double)this.fish.getSpeed() * (d1 / d3) * 0.1, 0.0));
                    }
                    if (d0 != 0.0 || d2 != 0.0) {
                        float f1 = (float)(Mth.atan2((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                        this.fish.setYRot(this.rotlerp(this.fish.getYRot(), f1, 90.0f));
                        this.fish.yBodyRot = this.fish.getYRot();
                    }
                } else {
                    float f = (float)(this.speedModifier * this.fish.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    this.fish.setSpeed(Mth.lerp((float)0.125f, (float)this.fish.getSpeed(), (float)f));
                    double d0 = this.wantedX - this.fish.getX();
                    double d1 = this.wantedY - this.fish.getY();
                    double d2 = this.wantedZ - this.fish.getZ();
                    if (d1 != 0.0) {
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(0.0, (double)this.fish.getSpeed() * (d1 / d3) * 0.1, 0.0));
                    }
                    if (d0 != 0.0 || d2 != 0.0) {
                        float f1 = (float)(Mth.atan2((double)d2, (double)d0) * 180.0 / 3.1415927410125732) - 90.0f;
                        this.fish.setYRot(this.rotlerp(this.fish.getYRot(), f1, 90.0f));
                        this.fish.yBodyRot = this.fish.getYRot();
                    }
                }
            } else {
                this.fish.setSpeed(0.0f);
            }
        }
    }
}

