/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dakotapride.creategarnished.CreateGarnished;
import net.dakotapride.creategarnished.entity.VoltfishEntity;
import net.dakotapride.creategarnished.entity.client.VoltfishAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class VoltfishModel<T extends VoltfishEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(CreateGarnished.asResource("voltfish"), "main");
    private final ModelPart body;
    private final ModelPart head;

    public VoltfishModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -4.3502f, -4.1667f, 5.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.3502f, (float)-2.8333f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 33).addBox(-2.5f, -2.25f, -5.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.8998f, (float)-4.1667f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 34).addBox(-2.475f, 0.0f, -3.0f, 4.95f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.75f, (float)0.0f));
        PartDefinition fins = body.addOrReplaceChild("fins", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.4503f, (float)2.8333f));
        PartDefinition left = fins.addOrReplaceChild("left", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-2.3005f, (float)-4.0f));
        PartDefinition cube_r1 = left.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(26, 17).addBox(0.0f, -1.0f, -1.0f, 1.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition right = fins.addOrReplaceChild("right", CubeListBuilder.create(), PartPose.offset((float)-2.6288f, (float)-2.3498f, (float)-4.0f));
        PartDefinition cube_r2 = right.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1288f, (float)0.0493f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition back = fins.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, -1.5f, 0.0f, 1.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.5505f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(VoltfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        if (!entity.isAggressive()) {
            this.animate(entity.idleAnimationState, VoltfishAnimations.ANIM_VOLTFISH_IDLE, ageInTicks, 1.0f);
        } else {
            this.animate(entity.idleAnimationState, VoltfishAnimations.ANIM_VOLTFISH_HASTEN, ageInTicks, 1.0f);
        }
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int colour) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, colour);
    }

    public ModelPart root() {
        return this.body;
    }
}

