/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event;

import net.dakotapride.creategarnished.registry.CreateGarnishedBlocks;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="creategarnished", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class CreateGarnishedColourManager {
    @SubscribeEvent
    public static void onColourHandlers$blockRegister(RegisterColorHandlersEvent.Block event) {
        CreateGarnishedColourManager.blockColourProvider(event.getBlockColors());
    }

    @SubscribeEvent
    public static void onColourHandlers$itemRegister(RegisterColorHandlersEvent.Item event) {
        CreateGarnishedColourManager.itemColourProvider(event.getBlockColors(), event.getItemColors());
    }

    public static synchronized void blockColourProvider(BlockColors colors) {
        colors.register((blockState, tintGetter, blockPos, i) -> FoliageColor.getEvergreenColor(), new Block[]{(Block)CreateGarnishedBlocks.PINE_NUT_LEAVES.get()});
        colors.register((blockState, tintGetter, blockPos, i) -> FoliageColor.getBirchColor(), new Block[]{(Block)CreateGarnishedBlocks.HAZELNUT_LEAVES.get()});
    }

    public static synchronized void itemColourProvider(BlockColors colors, ItemColors itemColors) {
        ItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return colors.getColor(state, null, null, tintIndex);
        };
        itemColors.register(itemBlockColourHandler, new ItemLike[]{(ItemLike)CreateGarnishedBlocks.PINE_NUT_LEAVES.get(), (ItemLike)CreateGarnishedBlocks.HAZELNUT_LEAVES.get()});
    }
}

