/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event;

import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedDamageSources;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatusEffects;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.GAME)
public class NutAllergyEvents {
    @SubscribeEvent
    public static void applyNutAllergyFromFluid(EntityTickEvent.Post event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        BlockPos pos = entity.blockPosition();
        FluidState fluidState = entity.level().getFluidState(pos);
        if (((Boolean)CreateGarnishedConfigs.server().entity.enableNutAllergy.get()).booleanValue() && entity instanceof LivingEntity && !(living = (LivingEntity)entity).hasEffect(CreateGarnishedStatusEffects.NUT_ALLERGY) && fluidState.is(CreateGarnishedTags.APPLIES_NUT_ALLERGY)) {
            living.addEffect(new MobEffectInstance(CreateGarnishedStatusEffects.NUT_ALLERGY, 2400, 0, false, false, false));
        }
    }

    @SubscribeEvent
    public static void applyNutAllergyConsequences(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getItem();
        if (stack.is(CreateGarnishedTags.CAUSES_NUT_ALLERGY_CONSEQUENCES) && entity.hasEffect(CreateGarnishedStatusEffects.NUT_ALLERGY)) {
            entity.hurt(CreateGarnishedDamageSources.nutAllergy(entity.level()), ((Double)CreateGarnishedConfigs.server().entity.nutAllergyDamageAmount.get()).floatValue());
        }
    }
}

