/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event;

import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;

@EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.GAME)
public class ProvideEffectsFromConsumptionEvent {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void provideEffectsFromConsumingFoods(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStack = event.getItem();
        LivingEntity entity = event.getEntity();
        Holder biome = entity.level().getBiome(entity.blockPosition());
        if (((Boolean)CreateGarnishedConfigs.server().entity.provideSpecialEffectsFromBiome.get()).booleanValue()) {
            for (YoinkFromHereList list : YoinkFromHereList.values()) {
                boolean isInBiome = biome.is(list.getBiomeTagKey());
                if (!itemStack.is(list.getItemTagKey()) || !isInBiome) continue;
                ProvideEffectsFromConsumptionEvent.pullEffect(entity, list.getEffectHolder());
            }
        }
    }

    private static void pullEffect(LivingEntity entity, Holder<MobEffect> effectHolder) {
        entity.addEffect(new MobEffectInstance(effectHolder, 2400, 1, false, false, false));
    }

    static enum YoinkFromHereList {
        JUNGLE(CreateGarnishedTags.JUNGLE_SPECIAL_FOODS, (TagKey<Biome>)BiomeTags.IS_JUNGLE, (Holder<MobEffect>)MobEffects.DIG_SPEED),
        FLOWER_FOREST(CreateGarnishedTags.FLOWER_FOREST_SPECIAL_FOODS, CreateGarnishedTags.IS_ACCEPTED_FLOWER_BIOME, (Holder<MobEffect>)MobEffects.REGENERATION),
        BIRCH_FOREST(CreateGarnishedTags.BIRCH_FOREST_SPECIAL_FOODS, (TagKey<Biome>)Tags.Biomes.IS_BIRCH_FOREST, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED),
        TAIGA(CreateGarnishedTags.TAIGA_SPECIAL_FOODS, (TagKey<Biome>)BiomeTags.IS_TAIGA, (Holder<MobEffect>)MobEffects.INVISIBILITY);

        final TagKey<Item> itemTagKey;
        final TagKey<Biome> biomeTagKey;
        final Holder<MobEffect> effectHolder;

        private YoinkFromHereList(TagKey<Item> itemTagKey, TagKey<Biome> biomeTagKey, Holder<MobEffect> effectHolder) {
            this.itemTagKey = itemTagKey;
            this.biomeTagKey = biomeTagKey;
            this.effectHolder = effectHolder;
        }

        public TagKey<Item> getItemTagKey() {
            return this.itemTagKey;
        }

        public TagKey<Biome> getBiomeTagKey() {
            return this.biomeTagKey;
        }

        public Holder<MobEffect> getEffectHolder() {
            return this.effectHolder;
        }
    }
}

