/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event.hatchet;

import com.alganaut.hominid.registry.entity.HominidEntityCreator;
import net.dakotapride.creategarnished.event.hatchet.MobConditions;
import net.dakotapride.creategarnished.util.ModIds;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class HominidMobConditions
extends MobConditions {
    public static void applyConditions(LivingEntity entity, LivingEntity attacker, DamageSource source) {
        if (!((Boolean)HominidMobConditions.config.enableZombieDrops.get()).booleanValue()) {
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.FAMISHED.get(), attacker, Items.BONE, 2, 15, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.FAMISHED.get(), attacker, Items.ROTTEN_FLESH, 2, 45, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.FAMISHED.get(), attacker, Items.LEATHER, 2, 35, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.INCENDIARY.get(), attacker, Items.ROTTEN_FLESH, 2, 45, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.INCENDIARY.get(), attacker, Items.GUNPOWDER, 2, 35, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.JUGGERNAUT.get(), attacker, Items.ROTTEN_FLESH, 2, 45, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.JUGGERNAUT.get(), attacker, Items.IRON_INGOT, 2, 35, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.MELLIFIED.get(), attacker, Items.ROTTEN_FLESH, 2, 45, source);
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.MELLIFIED.get(), attacker, Items.HONEYCOMB, 2, 35, source);
        }
        if (!((Boolean)HominidMobConditions.config.enableSkeletonDrops.get()).booleanValue()) {
            HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.FOSSILISED.get(), attacker, Items.STONE, 4, 65, source);
        }
        HominidMobConditions.createHominidDropConditions(entity, (EntityType)HominidEntityCreator.VAMPIRE.get(), attacker, Items.ROTTEN_FLESH, 2, 15, source);
    }

    public static void createHominidDropConditions(LivingEntity entity, EntityType<?> entityType, LivingEntity attacker, Item item, int maxCount, int chance, DamageSource source) {
        HominidMobConditions.createDropConditions(entity, entityType, attacker, item, maxCount, chance, source, ModIds.HOMINID.isLoaded());
    }

    @EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.GAME)
    static class PastelConditionsEvent {
        PastelConditionsEvent() {
        }

        @SubscribeEvent
        private static void createHominidConditions(LivingDeathEvent event) {
            LivingEntity attacker;
            Entity entity;
            LivingEntity entity2 = event.getEntity();
            DamageSource source = event.getSource();
            if (source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity && MobConditions.accept(attacker = (LivingEntity)entity) && ModIds.HOMINID.isLoaded()) {
                HominidMobConditions.applyConditions(entity2, attacker, source);
            }
        }
    }
}

