/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event.hatchet;

import java.util.Random;
import net.dakotapride.creategarnished.config.HatchetConfig;
import net.dakotapride.creategarnished.item.PressurisedHatchetItem;
import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatisics;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatusEffects;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.dakotapride.creategarnished.registry.CreateGarnishedTriggers;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MobConditions {
    public static HatchetConfig config = CreateGarnishedConfigs.server().hatchet;
    public static boolean global = (Boolean)MobConditions.config.enableGlobalHatchetDrops.get();
    public static boolean volt = (Boolean)MobConditions.config.enableVoltDrops.get();

    public static boolean accept(LivingEntity attacker) {
        return attacker.getMainHandItem().getItem() instanceof PressurisedHatchetItem || attacker.getMainHandItem().is(CreateGarnishedTags.HATCHETS);
    }

    public static boolean requireSpecificHatchetItem(LivingEntity attacker, Item item) {
        return attacker.getMainHandItem().is(item) && MobConditions.accept(attacker);
    }

    public static void createSoundEvents(LivingEntity attacker) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                server.playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.SOUL_ESCAPE, player.getSoundSource(), 2.0f, 1.0f);
                if (player.hasEffect(MobEffects.LUCK) && ((Boolean)CreateGarnishedConfigs.client().allowLuckyPlingSoundEvent.get()).booleanValue()) {
                    server.playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.NOTE_BLOCK_PLING, player.getSoundSource(), 0.5f, 1.0f);
                }
            }
        }
    }

    public static void createVoltStruckEffects(LivingEntity entity, EntityType<?> matchType, EntityType<?> anomaly, LivingEntity attacker, boolean ... enabled0) {
        EntityType type = entity.getType();
        boolean enabled1 = false;
        boolean[] blArray = enabled0;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean b;
            enabled1 = b = blArray[i];
        }
        if (type == matchType && attacker.hasEffect(CreateGarnishedStatusEffects.VOLT_STRUCK) && enabled1 && ((Boolean)MobConditions.config.enableHatchetDrops.get()).booleanValue() && volt) {
            Entity anomalyEntity = anomaly.create(attacker.level());
            anomalyEntity.setPos(entity.getPosition(0.0f));
            attacker.level().addFreshEntity(anomalyEntity);
        }
    }

    public static void createDropConditions(LivingEntity entity, EntityType<?> matchType, LivingEntity attacker, Item itemToDrop, int count, int chance, DamageSource source, boolean ... enabled0) {
        PressurisedHatchetItem hatchetItem;
        Item itemInHand;
        EntityType type = entity.getType();
        boolean attackerHasLuck = attacker.hasEffect(MobEffects.LUCK);
        boolean attackerHasUnluck = attacker.hasEffect(MobEffects.UNLUCK);
        int r = new Random().nextInt(1, 101);
        if (attackerHasLuck) {
            r = new Random().nextInt(1, 51);
        }
        if (attackerHasUnluck) {
            r = new Random().nextInt(1, 201);
        }
        if ((itemInHand = attacker.getMainHandItem().getItem()) instanceof PressurisedHatchetItem && (hatchetItem = (PressurisedHatchetItem)itemInHand).isCreative()) {
            chance = 100;
        }
        int r0 = new Random().nextInt(1, count + 1);
        boolean enabled1 = false;
        boolean[] blArray = enabled0;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            boolean b;
            enabled1 = b = blArray[i];
        }
        if (type == matchType && enabled1 && ((Boolean)MobConditions.config.enableHatchetDrops.get()).booleanValue() && r <= chance) {
            entity.spawnAtLocation(new ItemStack((ItemLike)itemToDrop, r0));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                CreateGarnishedTriggers.KILLED_USING_HATCHET.get().trigger(player, (Entity)entity, source);
                player.awardStat((ResourceLocation)CreateGarnishedStatisics.HATCHET_KILLS.get());
                if (entity.isBaby()) {
                    player.awardStat((ResourceLocation)CreateGarnishedStatisics.MONSTER_HATCHET_KILLS.get());
                }
                if (player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)CreateGarnishedStatisics.HATCHET_KILLS.get()))) >= 1000) {
                    CreateGarnishedTriggers.BLOODLUST.get().trigger(player, (Entity)entity, source);
                }
                if (player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)CreateGarnishedStatisics.MONSTER_HATCHET_KILLS.get()))) >= 1000) {
                    CreateGarnishedTriggers.MONSTER.get().trigger(player, (Entity)entity, source);
                }
            }
            MobConditions.createSoundEvents(attacker);
        }
    }
}

