/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event.hatchet;

import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.entity.EggLayingWoolyPigEntity;
import earth.terrarium.pastel.registries.PastelItems;
import net.dakotapride.creategarnished.event.hatchet.MobConditions;
import net.dakotapride.creategarnished.util.ModIds;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class PastelMobConditions
extends MobConditions {
    public static void applyConditions(LivingEntity entity, LivingEntity attacker, DamageSource source) {
        PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.EGG_LAYING_WOOLY_PIG.get(), attacker, Items.WHITE_WOOL, 2, 75, source);
        PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.EGG_LAYING_WOOLY_PIG.get(), attacker, Items.LEATHER, 2, 75, source);
        if (entity instanceof EggLayingWoolyPigEntity) {
            if (entity.isOnFire()) {
                PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.EGG_LAYING_WOOLY_PIG.get(), attacker, Items.COOKED_PORKCHOP, 2, 50, source);
            } else {
                PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.EGG_LAYING_WOOLY_PIG.get(), attacker, Items.PORKCHOP, 2, 50, source);
            }
        }
        PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.KINDLING.get(), attacker, (Item)PastelItems.DRAGONBONE_CHUNK.get(), 1, 25, source);
        PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.LIZARD.get(), attacker, (Item)PastelItems.LIZARD_MEAT.get(), 2, 50, source);
        PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.LIZARD.get(), attacker, Items.RABBIT_HIDE, 3, 45, source);
        PastelMobConditions.createPastelDropConditions(entity, (EntityType)PastelEntityTypes.LIZARD.get(), attacker, Items.LEATHER, 1, 15, source);
    }

    public static void createPastelDropConditions(LivingEntity entity, EntityType<?> entityType, LivingEntity attacker, Item item, int maxCount, int chance, DamageSource source) {
        PastelMobConditions.createDropConditions(entity, entityType, attacker, item, maxCount, chance, source, ModIds.PASTEL.isLoaded());
    }

    @EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.GAME)
    static class PastelConditionsEvent {
        PastelConditionsEvent() {
        }

        @SubscribeEvent
        private static void createPastelConditions(LivingDeathEvent event) {
            LivingEntity attacker;
            Entity entity;
            LivingEntity entity2 = event.getEntity();
            DamageSource source = event.getSource();
            if (source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity && MobConditions.accept(attacker = (LivingEntity)entity) && ModIds.PASTEL.isLoaded()) {
                PastelMobConditions.applyConditions(entity2, attacker, source);
            }
        }
    }
}

