/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.event.hatchet;

import net.dakotapride.creategarnished.event.hatchet.MobConditions;
import net.dakotapride.creategarnished.util.ModIds;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import reliquary.init.ModItems;

public class ReliquaryReincarnationsMobConditions
extends MobConditions {
    public static void applyConditions(LivingEntity entity, LivingEntity attacker, DamageSource source) {
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.ZOMBIE, attacker, (Item)ModItems.ZOMBIE_HEART.get(), 2, 25, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.PIGLIN, attacker, (Item)ModItems.ZOMBIE_HEART.get(), 2, 10, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.SQUID, attacker, (Item)ModItems.SQUID_BEAK.get(), 1, 50, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.SKELETON, attacker, (Item)ModItems.RIB_BONE.get(), 3, 40, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.STRAY, attacker, (Item)ModItems.RIB_BONE.get(), 3, 40, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.BOGGED, attacker, (Item)ModItems.RIB_BONE.get(), 3, 40, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.WITHER_SKELETON, attacker, (Item)ModItems.WITHERED_RIB.get(), 3, 40, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.CREEPER, attacker, (Item)ModItems.CATALYZING_GLAND.get(), 2, 35, source);
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (!creeper.isPowered()) {
                ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.CREEPER, attacker, (Item)ModItems.CATALYZING_GLAND.get(), 2, 35, source);
            }
            if (creeper.isPowered()) {
                ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.CREEPER, attacker, (Item)ModItems.EYE_OF_THE_STORM.get(), 2, 5, source);
            }
        }
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.GHAST, attacker, (Item)ModItems.CATALYZING_GLAND.get(), 1, 50, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.SPIDER, attacker, (Item)ModItems.CHELICERAE.get(), 2, 60, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.CAVE_SPIDER, attacker, (Item)ModItems.CHELICERAE.get(), 2, 60, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.SLIME, attacker, (Item)ModItems.SLIME_PEARL.get(), 2, 15, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.BAT, attacker, (Item)ModItems.BAT_WING.get(), 2, 80, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.BLAZE, attacker, (Item)ModItems.MOLTEN_CORE.get(), 2, 40, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.MAGMA_CUBE, attacker, (Item)ModItems.MOLTEN_CORE.get(), 2, 60, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.SNOW_GOLEM, attacker, (Item)ModItems.FROZEN_CORE.get(), 2, 40, source);
        ReliquaryReincarnationsMobConditions.createReliquaryReincarnationsDropConditions(entity, EntityType.ENDERMAN, attacker, (Item)ModItems.NEBULOUS_HEART.get(), 2, 40, source);
        ReliquaryReincarnationsMobConditions.guardianReliquaryDrops(entity, attacker, source);
    }

    public static void guardianReliquaryDrops(LivingEntity entity, LivingEntity attacker, DamageSource source) {
        if (ModIds.RELIQUARY.isLoaded()) {
            ReliquaryReincarnationsMobConditions.createDropConditions(entity, EntityType.GUARDIAN, attacker, (Item)ModItems.GUARDIAN_SPIKE.get(), (Integer)ReliquaryReincarnationsMobConditions.config.guardianSpikeMaxCount.get(), (Integer)ReliquaryReincarnationsMobConditions.config.chanceToDropGuardianSpike.get(), source, (Boolean)ReliquaryReincarnationsMobConditions.config.enableLesserGuardianDrops.get());
        }
    }

    public static void createReliquaryReincarnationsDropConditions(LivingEntity entity, EntityType<?> entityType, LivingEntity attacker, Item item, int maxCount, int chance, DamageSource source) {
        ReliquaryReincarnationsMobConditions.createDropConditions(entity, entityType, attacker, item, maxCount, chance, source, ModIds.RELIQUARY.isLoaded());
    }

    @EventBusSubscriber(modid="creategarnished", bus=EventBusSubscriber.Bus.GAME)
    static class ReliquaryReincarnationsConditionsEvent {
        ReliquaryReincarnationsConditionsEvent() {
        }

        @SubscribeEvent
        private static void createReliquaryReincarnationsConditions(LivingDeathEvent event) {
            LivingEntity attacker;
            Entity entity;
            LivingEntity entity2 = event.getEntity();
            DamageSource source = event.getSource();
            if (source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity && MobConditions.accept(attacker = (LivingEntity)entity) && ModIds.RELIQUARY.isLoaded()) {
                ReliquaryReincarnationsMobConditions.applyConditions(entity2, attacker, source);
            }
        }
    }
}

