/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.item;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import net.createmod.catnip.data.Pair;
import net.dakotapride.creategarnished.registry.CreateGarnishedItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class CandyWrapperUtils {
    public static ItemStack fill(FluidStack availableFluid, ItemStack stack) {
        ItemStack potionStack = new ItemStack((ItemLike)CreateGarnishedItems.WRAPPED_CANDY.asItem());
        potionStack.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)availableFluid.get(DataComponents.POTION_CONTENTS)));
        potionStack.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)stack.get(DataComponents.DYED_COLOR)));
        return potionStack;
    }

    public static boolean canFillInternally(FluidStack availableFluid) {
        Fluid fluid = availableFluid.getFluid();
        if (fluid.isSame((Fluid)Fluids.WATER)) {
            return true;
        }
        return fluid.isSame((Fluid)AllFluids.POTION.get());
    }

    public static Pair<FluidStack, ItemStack> empty(ItemStack stack, boolean simulate) {
        FluidStack fluid = CandyWrapperUtils.getFluidFromPotionItem(stack);
        ItemStack stack0 = new ItemStack((ItemLike)CreateGarnishedItems.WRAPPED_CANDY.asItem());
        stack0.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)stack.get(DataComponents.DYED_COLOR)));
        if (!simulate) {
            stack.shrink(1);
        }
        return Pair.of((Object)fluid, (Object)stack0);
    }

    public static FluidStack getFluidFromPotionItem(ItemStack stack) {
        PotionContents potion = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (potion.is(Potions.WATER) && potion.customEffects().isEmpty()) {
            return new FluidStack((Fluid)Fluids.WATER, 250);
        }
        FluidStack fluid = CandyWrapperUtils.getFluidFromPotion(potion, 250);
        fluid.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)PotionFluid.BottleType.REGULAR);
        return fluid;
    }

    public static FluidStack getFluidFromPotion(PotionContents potionContents, int amount) {
        if (potionContents.is(Potions.WATER)) {
            return new FluidStack((Fluid)Fluids.WATER, amount);
        }
        return PotionFluid.of((int)amount, (PotionContents)potionContents, (PotionFluid.BottleType)PotionFluid.BottleType.REGULAR);
    }

    public static ItemStack createItemStack(Item item, Holder<Potion> potion, ItemStack stack) {
        ItemStack itemstack = new ItemStack((ItemLike)item);
        itemstack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        itemstack.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)stack.get(DataComponents.DYED_COLOR)));
        return itemstack;
    }
}

