/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.item;

import net.dakotapride.creategarnished.registry.CreateGarnishedParticles;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatusEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MysteriousVoltBottleItem
extends Item {
    public MysteriousVoltBottleItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!level.isClientSide) {
                player.addEffect(new MobEffectInstance(CreateGarnishedStatusEffects.VOLT_STRUCK, 1200, 0));
                AreaEffectCloud cloud = new AreaEffectCloud(level, player.getX(), player.getY(), player.getZ());
                cloud.setOwner((LivingEntity)player);
                cloud.setRadius(2.0f);
                cloud.setDuration(200);
                cloud.setParticle((ParticleOptions)CreateGarnishedParticles.VOLT.get());
                cloud.addEffect(new MobEffectInstance(CreateGarnishedStatusEffects.VOLT_STRUCK, 100, 0));
                level.addFreshEntity((Entity)cloud);
                stack.shrink(1);
                player.addItem(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                return stack;
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is((Item)this)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

