/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.item;

import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.dakotapride.creategarnished.registry.CreateGarnishedTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class PancakesItem
extends Item {
    public PancakesItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (interactionTarget.getType().is(CreateGarnishedTags.FLAPJACK_ADJACENT_ENTITY) && PancakesItem.isFlapjack(interactionTarget) && player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            CreateGarnishedTriggers.FLAPJACK.get().trigger(server);
            stack.consume(1, (LivingEntity)player);
            if (interactionTarget instanceof TamableAnimal) {
                TamableAnimal animal = (TamableAnimal)interactionTarget;
                if (!animal.isSilent()) {
                    animal.level().playSound(null, animal.getX(), animal.getY(), animal.getZ(), SoundEvents.GENERIC_EAT, animal.getSoundSource(), 1.0f, 1.0f + (animal.getRandom().nextFloat() - animal.getRandom().nextFloat()) * 0.2f);
                }
                if (!animal.level().isClientSide && ((Boolean)CreateGarnishedConfigs.server().item.tameUponFlapjackAdvancement.get()).booleanValue()) {
                    if (animal.getRandom().nextInt(10) == 0 && !EventHooks.onAnimalTame((Animal)animal, (Player)player)) {
                        animal.tame(player);
                        animal.level().broadcastEntityEvent((Entity)animal, (byte)7);
                    } else {
                        animal.level().broadcastEntityEvent((Entity)animal, (byte)6);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public static boolean isFlapjack(LivingEntity entity) {
        return entity.hasCustomName() && entity.getName().getString().equalsIgnoreCase("flapjack");
    }
}

