/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.item;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.tool.CardboardSwordItem;
import com.simibubi.create.content.equipment.tool.KnockbackPacket;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.dakotapride.creategarnished.util.ModIds;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;

@EventBusSubscriber
public class PressurisedHatchetItem
extends Item {
    private Tier tier;
    private final boolean creative;

    public PressurisedHatchetItem(Item.Properties properties, boolean creative) {
        super(properties.attributes(AxeItem.createAttributes((Tier)Tiers.IRON, (float)6.0f, (float)-3.1f)).component(DataComponents.TOOL, (Object)Tiers.IRON.createToolProperties(BlockTags.MINEABLE_WITH_AXE)));
        this.creative = creative;
    }

    public PressurisedHatchetItem(Tier tier, Item.Properties properties, boolean creative) {
        super(properties.attributes(AxeItem.createAttributes((Tier)tier, (float)6.0f, (float)-3.1f)).component(DataComponents.TOOL, (Object)tier.createToolProperties(BlockTags.MINEABLE_WITH_AXE)));
        this.tier = tier;
        this.creative = creative;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public Tier getTier() {
        return this.tier != null ? this.tier : Tiers.IRON;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        if (((Boolean)CreateGarnishedConfigs.server().hatchet.enableShotgunAxe.get()).booleanValue()) {
            return super.getAttackDamageBonus(target, damage, damageSource) + 6.0f;
        }
        return super.getAttackDamageBonus(target, damage, damageSource);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        if (PressurisedHatchetItem.playerHasShieldUseIntent(context)) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = this.evaluateNewBlockState(level, blockpos, player, level.getBlockState(blockpos), context);
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = context.getItemInHand();
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
        }
        level.setBlock(blockpos, optional.get(), 11);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)optional.get()));
        if (player != null && itemstack.isDamageableItem()) {
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static boolean playerHasShieldUseIntent(UseOnContext context) {
        Player player = context.getPlayer();
        return context.getHand().equals((Object)InteractionHand.MAIN_HAND) && player.getOffhandItem().is(Items.SHIELD) && !player.isSecondaryUseActive();
    }

    private Optional<BlockState> evaluateNewBlockState(Level level, BlockPos pos, @Nullable Player player, BlockState state, UseOnContext ctx) {
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(ctx, ItemAbilities.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return optional;
        }
        Optional<BlockState> optional1 = Optional.ofNullable(state.getToolModifiedState(ctx, ItemAbilities.AXE_SCRAPE, false));
        if (optional1.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, pos, 0);
            return optional1;
        }
        Optional<BlockState> optional2 = Optional.ofNullable(state.getToolModifiedState(ctx, ItemAbilities.AXE_WAX_OFF, false));
        if (optional2.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, pos, 0);
            return optional2;
        }
        return Optional.empty();
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(itemAbility);
    }

    private static int maxUses() {
        return (Integer)CreateGarnishedConfigs.server().hatchet.maxPressurisedHatchetActions.get();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void calculateKnockbackFromShotgun(AttackEntityEvent event) {
        if (!((Boolean)CreateGarnishedConfigs.server().hatchet.enableShotgunAxe.get()).booleanValue()) {
            return;
        }
        Player attacker = event.getEntity();
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        ItemStack stack = attacker.getItemInHand(InteractionHand.MAIN_HAND);
        if (!stack.is(CreateGarnishedTags.HATCHETS)) {
            return;
        }
        float knockbackStrength = (float)(attacker.getAttributeValue(Attributes.ATTACK_KNOCKBACK) + 20.0);
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            knockbackStrength = EnchantmentHelper.modifyKnockback((ServerLevel)serverLevel, (ItemStack)stack, (Entity)target, (DamageSource)serverLevel.damageSources().playerAttack(attacker), (float)knockbackStrength);
        }
        if (attacker.isSprinting() && attacker.getAttackStrengthScale(0.5f) > 0.9f) {
            knockbackStrength += 1.0f;
        }
        if (knockbackStrength <= 0.0f) {
            return;
        }
        float yRot = attacker.getYRot();
        CardboardSwordItem.knockback((LivingEntity)target, (double)knockbackStrength, (float)yRot);
        if (target instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)target;
            CatnipServices.NETWORK.sendToClient(sp, (CustomPacketPayload)new KnockbackPacket(yRot, knockbackStrength));
        }
        attacker.setDeltaMovement(attacker.getDeltaMovement().multiply(0.6, 1.0, 0.6));
        attacker.setSprinting(false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnBlockBreak(BlockEvent.BreakEvent event) {
        if (!((Boolean)CreateGarnishedConfigs.server().hatchet.enableShotgunAxe.get()).booleanValue()) {
            PressurisedHatchetItem.findAndDamagePressurisedHatchet(event.getPlayer());
        } else {
            PressurisedHatchetItem.shotgunAxeGoBrrrrButOW(event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void shotgun(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor;
        if (((Boolean)CreateGarnishedConfigs.server().hatchet.enableShotgunAxe.get()).booleanValue() && event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND).is(CreateGarnishedTags.HATCHETS) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (((Boolean)CreateGarnishedConfigs.client().allowShotgunSoundEvent.get()).booleanValue()) {
                level.playSound(null, event.getPos(), SoundEvents.ANVIL_LAND, event.getPlayer().getSoundSource(), 10.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void shotgunAttack(AttackEntityEvent event) {
        Level level;
        if (((Boolean)CreateGarnishedConfigs.server().hatchet.enableShotgunAxe.get()).booleanValue() && event.getEntity().getMainHandItem().is(CreateGarnishedTags.HATCHETS) && (level = event.getEntity().level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (((Boolean)CreateGarnishedConfigs.client().allowShotgunSoundEvent.get()).booleanValue()) {
                level2.playSound(null, event.getEntity().blockPosition(), SoundEvents.ANVIL_LAND, event.getEntity().getSoundSource(), 10.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
        boolean success;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack heldStack = player.getMainHandItem();
        BlockEntity tileEntity = level.getBlockEntity(event.getPos());
        if (ModIds.FARMERS_DELIGHT.isLoaded() && player.isSecondaryUseActive() && !heldStack.isEmpty() && tileEntity instanceof CuttingBoardBlockEntity && heldStack.getItem() instanceof PressurisedHatchetItem && (success = ((CuttingBoardBlockEntity)tileEntity).carveToolOnBoard(player.getAbilities().instabuild ? heldStack.copy() : heldStack))) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private static void findAndDamagePressurisedHatchet(Player player) {
        if (player == null) {
            return;
        }
        if (player.level().isClientSide) {
            return;
        }
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemInMainHand = player.getMainHandItem();
        if (!itemInMainHand.is(CreateGarnishedTags.HATCHETS)) {
            itemInMainHand = player.getOffhandItem();
            equipmentSlot = EquipmentSlot.OFFHAND;
        }
        if (!itemInMainHand.is(CreateGarnishedTags.HATCHETS)) {
            return;
        }
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)player, (int)PressurisedHatchetItem.maxUses()) && itemInMainHand.isDamageableItem()) {
            itemInMainHand.hurtAndBreak(2, (LivingEntity)player, equipmentSlot);
        }
    }

    private static void shotgunAxeGoBrrrrButOW(Player player) {
        if (player == null) {
            return;
        }
        if (player.level().isClientSide) {
            return;
        }
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemInMainHand = player.getMainHandItem();
        if (!itemInMainHand.is(CreateGarnishedTags.HATCHETS)) {
            itemInMainHand = player.getOffhandItem();
            equipmentSlot = EquipmentSlot.OFFHAND;
        }
        if (!itemInMainHand.is(CreateGarnishedTags.HATCHETS)) {
            return;
        }
        if (!PressurisedHatchetItem.canShotgunAxeAbsorbDamage((LivingEntity)player, PressurisedHatchetItem.maxUses()) && itemInMainHand.isDamageableItem()) {
            itemInMainHand.hurtAndBreak(4, (LivingEntity)player, equipmentSlot);
        }
    }

    public static boolean canShotgunAxeAbsorbDamage(LivingEntity entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof Player && ((Player)entity).isCreative()) {
            return true;
        }
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)entity);
        if (backtanks.isEmpty()) {
            return false;
        }
        int cost = Math.max(BacktankUtil.maxAirWithoutEnchants() / usesPerTank, 1);
        BacktankUtil.consumeAir((LivingEntity)entity, (ItemStack)((ItemStack)backtanks.getFirst()), (int)(cost * 2));
        return true;
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)PressurisedHatchetItem.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)PressurisedHatchetItem.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)PressurisedHatchetItem.maxUses());
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    @SubscribeEvent
    public static void bufferLivingAttackEvent(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            PressurisedHatchetItem.findAndDamagePressurisedHatchet((Player)entity);
        }
    }

    public int getEnchantmentValue() {
        return this.tier != null ? this.tier.getEnchantmentValue() : Tiers.IRON.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return this.tier != null ? this.tier.getRepairIngredient().test(repair) : Tiers.IRON.getRepairIngredient().test(repair) || super.isValidRepairItem(toRepair, repair);
    }
}

