/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.item;

import java.util.List;
import net.dakotapride.creategarnished.util.ModIds;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class SpikeItem
extends SwordItem {
    final EntityType<?> type;

    public SpikeItem(EntityType<?> type, Item.Properties properties) {
        super((Tier)Tiers.IRON, properties);
        this.type = type;
    }

    @NotNull
    public Tier getTier() {
        return this.type == EntityType.ELDER_GUARDIAN ? Tiers.DIAMOND : Tiers.IRON;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> text, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, text, tooltipFlag);
        text.add((Component)Component.translatable((String)"creategarnished.text.obtained_from_entity", (Object[])new Object[]{Component.translatable((String)this.type.getDescriptionId()).withColor(12421836)}).withColor(8280967));
        if (this.type == EntityType.GUARDIAN && ModIds.RELIQUARY.isLoaded()) {
            text.add((Component)Component.literal((String)""));
            text.add((Component)Component.translatable((String)"creategarnished.text.mod_loaded.reliquary").withStyle(ChatFormatting.DARK_RED));
        }
    }
}

