/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.item;

import java.util.List;
import java.util.Random;
import net.dakotapride.creategarnished.registry.CreateGarnishedSounds;
import net.dakotapride.creategarnished.registry.CreateGarnishedTags;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WrappedCandyItem
extends Item {
    public WrappedCandyItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        return Component.translatable((String)"item.creategarnished.wrapped_candy");
    }

    @NotNull
    public SoundEvent getEatingSound() {
        return (SoundEvent)CreateGarnishedSounds.CANDY_WRAPPER_WRINKLES.get();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        Player player;
        Player player2 = player = livingEntity instanceof Player ? (Player)livingEntity : null;
        if (!level.isClientSide) {
            int random = new Random().nextInt(BuiltInRegistries.MOB_EFFECT.size());
            if (BuiltInRegistries.MOB_EFFECT.getHolder(random).isPresent() && ((Holder.Reference)BuiltInRegistries.MOB_EFFECT.getHolder(random).get()).is(CreateGarnishedTags.BLACKLISTED_FROM_CANDY)) {
                random = new Random().nextInt(BuiltInRegistries.MOB_EFFECT.size());
            }
            if (!((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects()) {
                livingEntity.addEffect(new MobEffectInstance((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(random).orElseThrow(), 140, 2));
            } else {
                PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                potionContents.forEachEffect(mobEffectInstance -> {
                    if (((MobEffect)mobEffectInstance.getEffect().value()).isInstantenous()) {
                        ((MobEffect)mobEffectInstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, livingEntity, 2, 1.0);
                    } else {
                        livingEntity.addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), mobEffectInstance.getAmplifier()));
                    }
                });
            }
        }
        return super.finishUsingItem(itemStack, level, livingEntity);
    }
}

