/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.mixin;

import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.dakotapride.creategarnished.item.CandyWrapperUtils;
import net.dakotapride.creategarnished.registry.CreateGarnishedItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GenericItemFilling.class}, remap=false)
public class GenericItemFillingMixin {
    @Inject(method={"canItemBeFilled"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canItemBeFilled(Level world, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.getItem() == CreateGarnishedItems.WRAPPED_CANDY.asItem() && !((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getRequiredAmountForItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getRequiredAmountForItem(Level world, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<Integer> cir) {
        if (stack.getItem() == CreateGarnishedItems.WRAPPED_CANDY.asItem() && CandyWrapperUtils.canFillInternally(availableFluid)) {
            cir.setReturnValue((Object)250);
        }
    }

    @Inject(method={"fillItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fillItem(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<ItemStack> cir) {
        if (stack.getItem() == CreateGarnishedItems.WRAPPED_CANDY.asItem()) {
            FluidStack toFill = availableFluid.copy();
            toFill.setAmount(requiredAmount);
            availableFluid.shrink(requiredAmount);
            if (CandyWrapperUtils.canFillInternally(toFill)) {
                Fluid fluid = toFill.getFluid();
                ItemStack fillBottle = FluidHelper.isWater((Fluid)fluid) ? CandyWrapperUtils.createItemStack(CreateGarnishedItems.WRAPPED_CANDY.asItem(), (Holder<Potion>)Potions.WATER, stack) : CandyWrapperUtils.fill(toFill, stack);
                stack.shrink(1);
                cir.setReturnValue((Object)fillBottle);
            }
        }
    }
}

