/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.mixin;

import net.dakotapride.creategarnished.CreateGarnished;
import net.dakotapride.creategarnished.registry.CreateGarnishedStatusEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Gui.class}, remap=false)
public class GuiMixin {
    @Inject(method={"renderHeart"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHeart(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean halfHeart, boolean blinking, CallbackInfo ci) {
        Player player;
        Entity entity;
        if (heartType == Gui.HeartType.NORMAL && (entity = Minecraft.getInstance().cameraEntity) instanceof Player && (player = (Player)entity).hasEffect(CreateGarnishedStatusEffects.VOLT_STRUCK)) {
            guiGraphics.blitSprite(this.getSprite(hardcore, blinking, halfHeart, CreateGarnished.asResource("hud/heart/volt_half_blinking"), CreateGarnished.asResource("hud/heart/volt_half"), CreateGarnished.asResource("hud/heart/volt_full_blinking"), CreateGarnished.asResource("hud/heart/volt_full"), CreateGarnished.asResource("hud/heart/volt_hardcore_half_blinking"), CreateGarnished.asResource("hud/heart/volt_hardcore_half"), CreateGarnished.asResource("hud/heart/volt_hardcore_full_blinking"), CreateGarnished.asResource("hud/heart/volt_hardcore_full")), x, y, 9, 9);
            ci.cancel();
        }
    }

    @Unique
    public ResourceLocation getSprite(boolean hardcore, boolean halfHeart, boolean blinking, ResourceLocation halfBlinking, ResourceLocation half, ResourceLocation fullBlinking, ResourceLocation full, ResourceLocation hardcoreHalfBlinking, ResourceLocation hardcoreHalf, ResourceLocation hardcoreFullBlinking, ResourceLocation hardcoreFull) {
        if (!hardcore) {
            if (halfHeart) {
                return blinking ? halfBlinking : half;
            }
            return blinking ? fullBlinking : full;
        }
        if (halfHeart) {
            return blinking ? hardcoreHalfBlinking : hardcoreHalf;
        }
        return blinking ? hardcoreFullBlinking : hardcoreFull;
    }
}

