/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CaramelParticle
extends TextureSheetParticle {
    protected CaramelParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= (double)0.3f;
        this.yd = Math.random() * (double)0.2f + (double)0.1f;
        this.zd *= (double)0.3f;
        this.quadSize *= 0.75f;
        this.gravity = 0.03f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            BlockPos blockpos;
            double d0;
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.98f;
            this.yd *= (double)0.98f;
            this.zd *= (double)0.98f;
            if (this.onGround) {
                if (Math.random() < 0.5) {
                    this.remove();
                }
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
            if ((d0 = Math.max(this.level.getBlockState(blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).getCollisionShape((BlockGetter)this.level, blockpos).max(Direction.Axis.Y, this.x - (double)blockpos.getX(), this.z - (double)blockpos.getZ()), (double)this.level.getFluidState(blockpos).getHeight((BlockGetter)this.level, blockpos))) > 0.0 && this.y < (double)blockpos.getY() + d0) {
                this.remove();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprites) {
            this.sprite = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CaramelParticle caramelParticle = new CaramelParticle(level, x, y, z);
            caramelParticle.pickSprite(this.sprite);
            return caramelParticle;
        }
    }
}

