/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.creategarnished.registry;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.dakotapride.creategarnished.CreateGarnished;
import net.dakotapride.creategarnished.registry.CreateGarnishedConfigs;
import net.dakotapride.creategarnished.registry.CreateGarnishedCreativeModeTabs;
import net.dakotapride.creategarnished.registry.CreateGarnishedStoneTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class CreateGarnishedFluids {
    public static final FluidEntry<VirtualFluid> SPRINTERS_TEA;
    public static final FluidEntry<VirtualFluid> SWEET_TEA;
    public static final FluidEntry<VirtualFluid> ELVEN_TEA;
    public static final FluidEntry<VirtualFluid> BIRCH_SAP;
    public static final FluidEntry<VirtualFluid> CORN_SYRUP;
    public static final FluidEntry<VirtualFluid> CARAMEL;
    public static final FluidEntry<BaseFlowingFluid.Flowing> PEANUT_BUTTER;
    public static final FluidEntry<BaseFlowingFluid.Flowing> BIRCH_SYRUP;
    public static final FluidEntry<BaseFlowingFluid.Flowing> ALMOND_EXTRACT;
    public static final FluidEntry<BaseFlowingFluid.Flowing> ROYAL_CIDER;
    public static final FluidEntry<BaseFlowingFluid.Flowing> BEETROOT_JUICE;
    public static final FluidEntry<BaseFlowingFluid.Flowing> MUSHROOM_SLOP;

    public static void register() {
    }

    private static void provideFluidInteraction(FluidType colliding_fluid, FluidType met_fluid, Block from_source, Block from_flowing) {
        FluidInteractionRegistry.addInteraction((FluidType)colliding_fluid, (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(met_fluid, fluidState -> {
            if (fluidState.isSource()) {
                return from_source.defaultBlockState();
            }
            return from_flowing.defaultBlockState();
        }));
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)BIRCH_SYRUP.get()).getFluidType(), fluidState -> {
            if (((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowCrimsiteFluidInteraction.get()).booleanValue()) {
                if (fluidState.isSource()) {
                    return ((Block)AllPaletteStoneTypes.CRIMSITE.getBaseBlock().get()).defaultBlockState();
                }
                return ((Block)CreateGarnishedStoneTypes.PORPHYRY.getStoneType().getBaseStoneBlock().get()).defaultBlockState();
            }
            return ((Block)CreateGarnishedStoneTypes.PORPHYRY.getStoneType().getBaseStoneBlock().get()).defaultBlockState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)PEANUT_BUTTER.get()).getFluidType(), fluidState -> {
            if (((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowDripstoneFluidInteraction.get()).booleanValue()) {
                return ((Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get()).defaultBlockState();
            }
            if (fluidState.isSource()) {
                return Blocks.STONE.defaultBlockState();
            }
            return Blocks.COBBLESTONE.defaultBlockState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)ALMOND_EXTRACT.get()).getFluidType(), fluidState -> {
            if (((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowPackedMudFluidInteraction.get()).booleanValue()) {
                return Blocks.PACKED_MUD.defaultBlockState();
            }
            if (fluidState.isSource()) {
                return Blocks.STONE.defaultBlockState();
            }
            return Blocks.COBBLESTONE.defaultBlockState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)MUSHROOM_SLOP.get()).getFluidType(), fluidState -> {
            if (((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowPackedMudFluidInteraction.get()).booleanValue()) {
                return Blocks.PACKED_MUD.defaultBlockState();
            }
            if (fluidState.isSource()) {
                return Blocks.STONE.defaultBlockState();
            }
            return Blocks.COBBLESTONE.defaultBlockState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)BEETROOT_JUICE.get()).getFluidType(), fluidState -> {
            if (((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowGraniteFluidInteraction.get()).booleanValue()) {
                return ((Block)AllPaletteStoneTypes.GRANITE.getBaseBlock().get()).defaultBlockState();
            }
            if (fluidState.isSource()) {
                return Blocks.STONE.defaultBlockState();
            }
            return Blocks.COBBLESTONE.defaultBlockState();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((BaseFlowingFluid.Flowing)ROYAL_CIDER.get()).getFluidType(), fluidState -> {
            if (((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowAsurineFluidInteraction.get()).booleanValue()) {
                if (fluidState.isSource()) {
                    return ((Block)AllPaletteStoneTypes.ASURINE.getBaseBlock().get()).defaultBlockState();
                }
                return Blocks.CRYING_OBSIDIAN.defaultBlockState();
            }
            return Blocks.CRYING_OBSIDIAN.defaultBlockState();
        }));
    }

    @NotNull
    public static BlockState getFluidInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.getType();
        if (fluid.isSame((Fluid)BIRCH_SYRUP.get())) {
            return CreateGarnishedStoneTypes.PORPHYRY.getStoneType().getBaseStoneBlock().getDefaultState();
        }
        if (fluid.isSame((Fluid)PEANUT_BUTTER.get()) && ((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowDripstoneFluidInteraction.get()).booleanValue()) {
            return ((Block)AllPaletteStoneTypes.DRIPSTONE.getBaseBlock().get()).defaultBlockState();
        }
        if (fluid.isSame((Fluid)ALMOND_EXTRACT.get()) && ((Boolean)CreateGarnishedConfigs.server().stoneGeneration.allowGraniteFluidInteraction.get()).booleanValue()) {
            return ((Block)AllPaletteStoneTypes.GRANITE.getBaseBlock().get()).defaultBlockState();
        }
        if (fluid.isSame((Fluid)ROYAL_CIDER.get())) {
            return Blocks.CRYING_OBSIDIAN.defaultBlockState();
        }
        return Blocks.COBBLESTONE.defaultBlockState();
    }

    static {
        CreateGarnished.REGISTRATE.setCreativeTab(CreateGarnishedCreativeModeTabs.GARNISHED);
        SPRINTERS_TEA = CreateGarnished.REGISTRATE.virtualFluid("sprinters_tea").register();
        SWEET_TEA = CreateGarnished.REGISTRATE.virtualFluid("sweet_tea").register();
        ELVEN_TEA = CreateGarnished.REGISTRATE.virtualFluid("elven_tea").register();
        BIRCH_SAP = CreateGarnished.REGISTRATE.virtualFluid("birch_sap").register();
        CORN_SYRUP = CreateGarnished.REGISTRATE.virtualFluid("corn_syrup").register();
        CARAMEL = CreateGarnished.REGISTRATE.virtualFluid("caramel").register();
        PEANUT_BUTTER = ((FluidBuilder)CreateGarnished.REGISTRATE.standardFluid("peanut_butter", SolidRenderedPlaceableFluidType.create(10647371, () -> Float.valueOf(0.03125f * CreateGarnishedConfigs.client().peanutButterTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        BIRCH_SYRUP = ((FluidBuilder)CreateGarnished.REGISTRATE.standardFluid("birch_syrup", SolidRenderedPlaceableFluidType.create(10373919, () -> Float.valueOf(0.03125f * CreateGarnishedConfigs.client().birchSyrupTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        ALMOND_EXTRACT = ((FluidBuilder)CreateGarnished.REGISTRATE.standardFluid("almond_extract", SolidRenderedPlaceableFluidType.create(10373919, () -> Float.valueOf(0.03125f * CreateGarnishedConfigs.client().almondExtractTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        ROYAL_CIDER = ((FluidBuilder)CreateGarnished.REGISTRATE.standardFluid("royal_cider", SolidRenderedPlaceableFluidType.create(10373919, () -> Float.valueOf(0.03125f * CreateGarnishedConfigs.client().royalCiderTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        BEETROOT_JUICE = ((FluidBuilder)CreateGarnished.REGISTRATE.standardFluid("beetroot_juice", SolidRenderedPlaceableFluidType.create(10757932, () -> Float.valueOf(0.03125f * CreateGarnishedConfigs.client().beetrootJuiceTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        MUSHROOM_SLOP = ((FluidBuilder)CreateGarnished.REGISTRATE.standardFluid("mushroom_slop", SolidRenderedPlaceableFluidType.create(12482654, () -> Float.valueOf(0.03125f * CreateGarnishedConfigs.client().mushroomSlopTransparencyMultiplier.getF()))).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).bucket().build()).register();
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

