/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.copergolem.procedures;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CopperbedOnBlockRightClickedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (CopperbedOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.NORTH) {
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(x, y, z - 1.0), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), "spawnpoint @p");
            }
        } else if (CopperbedOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.SOUTH) {
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(x, y, z + 1.0), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), "spawnpoint @p");
            }
        } else if (CopperbedOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z)) == Direction.WEST) {
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(x - 1.0, y, z), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), "spawnpoint @p");
            }
        } else if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(x + 1.0, y, z), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), "spawnpoint @p");
        }
        entity.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"copergolem:lay_in_copper_bed")))), 3.0f);
    }

    private static Direction getBlockDirection(LevelAccessor world, BlockPos pos) {
        Comparable comparable;
        BlockState blockState = world.getBlockState(pos);
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property != null && (comparable = blockState.getValue(property)) instanceof Direction) {
            Direction direction = (Direction)comparable;
            return direction;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

