/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import gg.projecteden.titan.config.Config;
import gg.projecteden.titan.config.ConfigItem;
import gg.projecteden.titan.config.annotations.Description;
import gg.projecteden.titan.config.annotations.Disabled;
import gg.projecteden.titan.config.annotations.Group;
import gg.projecteden.titan.config.annotations.Name;
import gg.projecteden.titan.utils.Utils;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ModMenuImpl
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return ModMenuImpl::getConfigScreen;
    }

    public static class_437 getConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43470((String)"Titan Config"));
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        LinkedHashMap<String, ConfigCategory> categories = new LinkedHashMap<String, ConfigCategory>();
        for (Field field : ConfigItem.getAllNonDeveloperOptions()) {
            ModMenuImpl.addOption(builder, entryBuilder, categories, field);
        }
        if (class_437.method_25441()) {
            for (Field field : ConfigItem.getDeveloperOptions()) {
                ModMenuImpl.addOption(builder, entryBuilder, categories, field);
            }
        }
        builder.setDoesConfirmSave(false);
        builder.transparentBackground();
        builder.setSavingRunnable(Config::save);
        builder.setParentScreen(parent);
        return builder.build();
    }

    public static void addOption(ConfigBuilder builder, ConfigEntryBuilder entryBuilder, Map<String, ConfigCategory> categories, Field field) {
        try {
            StringFieldBuilder selector;
            if (field.isAnnotationPresent(Disabled.class)) {
                return;
            }
            ConfigItem item = (ConfigItem)field.get(null);
            class_5250 name = class_2561.method_43470((String)(field.isAnnotationPresent(Name.class) ? field.getAnnotation(Name.class).value() : field.getName()));
            class_5250 description = field.isAnnotationPresent(Description.class) ? class_2561.method_43470((String)field.getAnnotation(Description.class).value()) : null;
            switch (item.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case BOOLEAN: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startBooleanToggle((class_2561)name, ((Boolean)item.getValue()).booleanValue());
                    break;
                }
                case ENUM: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startEnumSelector((class_2561)name, item.getValue().getClass(), (Enum)item.getValue()).setEnumNameProvider(val -> class_2561.method_43470((String)Utils.camelCase(((Enum)val).name())));
                    break;
                }
                case INTEGER: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startIntField((class_2561)name, ((Integer)item.getValue()).intValue());
                    break;
                }
                case DOUBLE: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startDoubleField((class_2561)name, ((Double)item.getValue()).doubleValue());
                    break;
                }
                case STRING: {
                    StringFieldBuilder stringFieldBuilder = entryBuilder.startStrField((class_2561)name, (String)item.getValue());
                    break;
                }
                case UNKNOWN: {
                    StringFieldBuilder stringFieldBuilder = selector = null;
                }
            }
            if (selector == null) {
                return;
            }
            selector.setDefaultValue(item.getDefaultValue());
            selector.setSaveConsumer(val -> {
                item.setValue(val);
                item.onUpdate(val);
            });
            selector.setTooltip(new class_2561[]{description});
            categories.computeIfAbsent(field.isAnnotationPresent(Group.class) ? field.getAnnotation(Group.class).value() : "Default", cat -> builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)cat))).addEntry(selector.build());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

