/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.discord;

import gg.projecteden.titan.discord.RichPresence;
import gg.projecteden.titan.utils.Utils;
import lombok.Generated;

public class PlayerStates {
    private static String worldGroup;
    private static String mode;
    private static boolean vanished;
    private static boolean AFK;
    private static ChatChannel channel;

    public static void setVanished(boolean vanished) {
        boolean oldVanished = PlayerStates.vanished;
        PlayerStates.vanished = vanished;
        if (!vanished && oldVanished) {
            RichPresence.start();
        }
        if (vanished) {
            RichPresence.stop();
        }
    }

    public static void setAFK(boolean afk) {
        AFK = afk;
        RichPresence.updateWorld();
        if (afk) {
            RichPresence.setTimestamp();
        } else {
            RichPresence.resetTimestamp();
        }
    }

    public static void setWorldGroup(String worldGroup) {
        PlayerStates.worldGroup = worldGroup;
        RichPresence.updateWorld();
    }

    public static String getWorldDetails() {
        Object details = "";
        if (AFK) {
            details = (String)details + "AFK ";
        }
        details = (String)details + "in " + PlayerStates.transformWorldGroup();
        return details;
    }

    public static String transformWorldGroup() {
        if (worldGroup == null) {
            return "Unknown";
        }
        return switch (worldGroup.toLowerCase()) {
            case "staff" -> "a Staff World";
            case "server" -> "Hub";
            default -> Utils.camelCase(worldGroup);
        };
    }

    @Generated
    public static String getWorldGroup() {
        return worldGroup;
    }

    @Generated
    public static String getMode() {
        return mode;
    }

    @Generated
    public static void setMode(String mode) {
        PlayerStates.mode = mode;
    }

    @Generated
    public static boolean isVanished() {
        return vanished;
    }

    @Generated
    public static boolean isAFK() {
        return AFK;
    }

    @Generated
    public static ChatChannel getChannel() {
        return channel;
    }

    @Generated
    public static void setChannel(ChatChannel channel) {
        PlayerStates.channel = channel;
    }

    static {
        channel = ChatChannel.UNKNOWN;
    }

    public static enum ChatChannel {
        GLOBAL("#00aa00", "g"),
        LOCAL("#ffff55", "l"),
        STAFF("#000000", "s"),
        OPERATOR("#00aaaa", "o"),
        ADMIN("#5555ff", "a"),
        MINIGAMES("#00aaaa", "m"),
        CREATIVE("#55ffff", "c"),
        SKYBLOCK("#ffaa00", "b"),
        PARTY("#ff55ff", "p"),
        PRIVATE("#55ffff", null),
        UNKNOWN(null, null);

        final String hex;
        String shortcut;

        public int getColor() {
            int rgb = Integer.parseInt(this.hex.substring(1), 16);
            return 0xFF000000 | rgb;
        }

        @Generated
        public String getHex() {
            return this.hex;
        }

        @Generated
        public String getShortcut() {
            return this.shortcut;
        }

        @Generated
        private ChatChannel(String hex, String shortcut) {
            this.hex = hex;
            this.shortcut = shortcut;
        }
    }
}

