/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.projecteden.titan.Titan;
import gg.projecteden.titan.network.models.PluginMessage;
import gg.projecteden.titan.network.models.Serverbound;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8702;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ServerClientMessaging {
    public static final Gson GSON = new GsonBuilder().create();
    public static final List<Serverbound> toSend = new ArrayList<Serverbound>();

    public static void send(Serverbound serverbound) {
        if (class_310.method_1551() != null && class_310.method_1551().method_1562() != null) {
            toSend.add(serverbound);
        } else {
            Titan.debug("Cannot send packets while not online");
        }
    }

    private static void flush() {
        if (toSend.isEmpty()) {
            return;
        }
        if (class_310.method_1551() == null || class_310.method_1551().method_1562() == null) {
            return;
        }
        Collections.reverse(toSend);
        JsonObject json = new JsonObject();
        toSend.forEach(serverbound -> {
            String type = serverbound.getType().name().toLowerCase();
            Titan.debug("Sending " + type);
            if (json.has(type)) {
                JsonObject original = json.getAsJsonObject(type);
                JsonObject duplicate = (JsonObject)GSON.fromJson(serverbound.getJson(), JsonObject.class);
                duplicate.keySet().forEach(key -> {
                    if (original.has(key)) {
                        return;
                    }
                    original.add(key, duplicate.get(key));
                });
            } else {
                json.add(serverbound.getType().name().toLowerCase(), (JsonElement)GSON.fromJson(serverbound.getJson(), JsonObject.class));
            }
        });
        ClientPlayNetworking.send((class_8710)new TitanPacket(GSON.toJson((JsonElement)json)));
        toSend.forEach(Serverbound::onSend);
        toSend.clear();
    }

    public static void init() {
        PayloadTypeRegistry.playC2S().register(TitanPacket.PACKET_ID, TitanPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(TitanPacket.PACKET_ID, TitanPacket.PACKET_CODEC);
        ClientPlayNetworking.registerGlobalReceiver(TitanPacket.PACKET_ID, (payload, context) -> context.client().execute(payload::receive));
        ClientTickEvents.END_CLIENT_TICK.register(client -> ServerClientMessaging.flush());
    }

    public record TitanPacket(String packet) implements class_8710
    {
        private static final class_2960 NETWORKING_CHANNEL = class_2960.method_60655((String)"titan", (String)"networking");
        public static final class_8710.class_9154<TitanPacket> PACKET_ID = new class_8710.class_9154(NETWORKING_CHANNEL);
        public static final class_9139<class_9129, TitanPacket> PACKET_CODEC = class_9139.method_56434((class_9139)new class_9139<ByteBuf, String>(){

            public String decode(ByteBuf byteBuf) {
                Titan.debug("Decoding...");
                Titan.debug("Readable bytes: " + byteBuf.readableBytes());
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                Titan.debug("Raw: " + Arrays.toString(bytes));
                String string = new String(bytes);
                Titan.debug("String: " + new String(bytes));
                string = string.substring(string.indexOf("{"));
                return string;
            }

            public void encode(ByteBuf byteBuf, String string) {
                Titan.debug("Encoding...");
                class_8702.method_53013((ByteBuf)byteBuf, (CharSequence)string, (int)10000);
            }
        }, TitanPacket::packet, TitanPacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }

        public String getPacket() {
            return this.packet;
        }

        public void receive() {
            Titan.debug("Received server message: " + this.getPacket());
            Titan.debug("Raw: " + this.packet);
            JsonObject json = (JsonObject)GSON.fromJson(this.getPacket(), JsonObject.class);
            if (json == null || json.isEmpty()) {
                Titan.debug("JSON is empty");
                return;
            }
            int processed = 0;
            for (PluginMessage message : PluginMessage.values()) {
                if (!json.has(message.name().toLowerCase())) continue;
                message.receive(json.getAsJsonObject(message.name().toLowerCase()));
                ++processed;
            }
            Titan.debug("Processed %d messages".formatted(processed));
        }
    }
}

