/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.utils;

import com.google.gson.Gson;
import com.mojang.serialization.DynamicOps;
import gg.projecteden.titan.Titan;
import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Scanner;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class Utils {
    private static final SimpleDateFormat ISOFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static String bash(String command, File directory) {
        InputStream result = Runtime.getRuntime().exec(command, null, directory).getInputStream();
        StringBuilder builder = new StringBuilder();
        new Scanner(result).forEachRemaining(string -> builder.append((String)string).append(" "));
        return builder.toString().trim();
    }

    public static boolean isOnEden() {
        class_634 handler = class_310.method_1551().method_1562();
        if (handler == null) {
            return false;
        }
        String address = handler.method_48296().method_10755().toString();
        if (address == null) {
            return false;
        }
        return address.contains("projecteden.gg") || address.contains("51.222.11.194");
    }

    public static String camelCase(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        return Arrays.stream(text.replaceAll("_", " ").split(" ")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getGitResponse(String get, Class<T> type) {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet request = new HttpGet("https://api.github.com/repos/ProjectEdenGG/" + get);
            request.addHeader("Accept", "application/vnd.github+json");
            request.addHeader("User-Agent", "Googlebot/2.1 (+http://www.google.com/bot.html)");
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            Object object = new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), type);
            return (T)object;
        }
        catch (Throwable ex) {
            Titan.log("An error occurred while checking git versioning. Rate limit reached?", new Object[0]);
            ex.printStackTrace();
            return null;
        }
    }

    public static String getManifestAttribute(String attribute) {
        try {
            URL jarURL = Utils.class.getResource("/gg/projecteden/titan/Titan.class");
            if (jarURL == null) {
                return "";
            }
            JarURLConnection jurlConn = (JarURLConnection)jarURL.openConnection();
            Manifest manifest = jurlConn.getManifest();
            return manifest.getMainAttributes().getValue(attribute);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String ISODate(Date date) {
        return ISOFormatter.format(date);
    }

    public static Date ISODate(String date) {
        try {
            return ISOFormatter.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class_2371<class_1799> getStoredItems(class_5455 registryManager, class_1799 stack) {
        class_2487 projectEden;
        if (!stack.method_57826(class_9334.field_49628)) {
            return class_2371.method_10211();
        }
        class_2487 nbt = ((class_9279)stack.method_58694(class_9334.field_49628)).method_57461();
        if (nbt != null && nbt.method_10545("ProjectEden") && (projectEden = (class_2487)nbt.method_10562("ProjectEden").get()).method_10545("Items")) {
            class_2371 items = class_2371.method_10211();
            HashMap<Integer, class_2487> slotMap = new HashMap<Integer, class_2487>();
            class_2499 tagList = (class_2499)projectEden.method_10554("Items").get();
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                byte slot = (Byte)((class_2487)tagList.method_10602(i).get()).method_10571("Slot").get();
                slotMap.put(Integer.valueOf(slot), (class_2487)tagList.method_10602(i).get());
            }
            int maxSlots = slotMap.keySet().stream().max(Integer::compareTo).orElse(0);
            for (int i = 0; i <= maxSlots; ++i) {
                if (!slotMap.containsKey(i)) {
                    items.add((Object)class_1799.field_8037);
                    continue;
                }
                try {
                    class_1799 stack2 = (class_1799)class_1799.field_24671.parse((DynamicOps)registryManager.method_57093((DynamicOps)class_2509.field_11560), (Object)((class_2520)slotMap.get(i))).getOrThrow();
                    items.add((Object)stack2);
                    continue;
                }
                catch (Throwable ex) {
                    Titan.log("Failed to load item: " + ((class_2487)slotMap.get(i)).toString(), new Object[0]);
                    ex.printStackTrace();
                }
            }
            return items;
        }
        return class_2371.method_10211();
    }
}

