/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.projecteden.titan.config.ConfigItem;
import gg.projecteden.titan.config.annotations.Disabled;
import gg.projecteden.titan.config.annotations.Group;
import gg.projecteden.titan.config.annotations.Name;
import gg.projecteden.titan.config.annotations.OldConfig;
import gg.projecteden.titan.network.ServerClientMessaging;
import gg.projecteden.titan.network.serverbound.TitanConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;

public class Config {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path GAME_CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    public static final File CONFIG_FILE = new File(Config.configDir(), "titan.json");

    public static File configDir() {
        File mapConfigDir = GAME_CONFIG_DIR.toFile();
        if (!mapConfigDir.exists()) {
            mapConfigDir.mkdirs();
        }
        return mapConfigDir;
    }

    public static JsonObject getJsonObject(File jsonFile) {
        if (jsonFile.exists()) {
            JsonObject jsonObject = Config.loadJson(jsonFile).getAsJsonObject();
            if (jsonObject == null) {
                return new JsonObject();
            }
            return jsonObject;
        }
        Config.save();
        return Config.getJsonObject(CONFIG_FILE);
    }

    public static JsonObject loadJson(File jsonFile) {
        if (jsonFile.exists()) {
            JsonObject jsonObject;
            FileReader reader = new FileReader(jsonFile);
            try {
                jsonObject = Config.loadJson(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ((Reader)reader).close();
            return jsonObject;
        }
        return new JsonObject();
    }

    public static JsonObject loadJson(Reader reader) {
        return (JsonObject)GSON.fromJson(reader, JsonObject.class);
    }

    public static void storeJson(File jsonFile, JsonElement jsonObject) {
        try (FileWriter writer = new FileWriter(jsonFile);){
            String json = GSON.toJson(jsonObject);
            writer.write(json);
            writer.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void save() {
        JsonObject jsonObject = new JsonObject();
        for (Field field : ConfigItem.getAllNonDeveloperOptions()) {
            try {
                if (field.isAnnotationPresent(Disabled.class)) continue;
                ConfigItem item = (ConfigItem)field.get(null);
                String group = field.getAnnotation(Group.class).value();
                String name = field.getAnnotation(Name.class).config().isEmpty() ? field.getName() : field.getAnnotation(Name.class).config();
                name = name.toLowerCase().replace("_", "-").replace(" ", "-");
                if (!jsonObject.has(group)) {
                    jsonObject.add(group, (JsonElement)new JsonObject());
                }
                JsonObject jsonGroup = jsonObject.getAsJsonObject(group);
                switch (item.getType()) {
                    case BOOLEAN: {
                        jsonGroup.addProperty(name, (Boolean)item.getValue());
                        break;
                    }
                    case ENUM: {
                        jsonGroup.addProperty(name, ((Enum)item.getValue()).name().toLowerCase());
                        break;
                    }
                    case INTEGER: {
                        jsonGroup.addProperty(name, (Number)((Integer)item.getValue()));
                        break;
                    }
                    case DOUBLE: {
                        jsonGroup.addProperty(name, (Number)((Double)item.getValue()));
                        break;
                    }
                    case STRING: {
                        jsonGroup.addProperty(name, (String)item.getValue());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Config.storeJson(CONFIG_FILE, (JsonElement)jsonObject);
        ServerClientMessaging.send(new TitanConfig());
    }

    public static void load() {
        JsonObject json = Config.getJsonObject(CONFIG_FILE);
        for (Field field : ConfigItem.getAllNonDeveloperOptions()) {
            try {
                String name;
                String group;
                if (field.isAnnotationPresent(Disabled.class)) continue;
                ConfigItem item = (ConfigItem)field.get(null);
                if (field.isAnnotationPresent(OldConfig.class)) {
                    group = field.getAnnotation(OldConfig.class).group();
                    name = field.getAnnotation(OldConfig.class).value();
                    if (json.has(group)) {
                        JsonObject jsonObject = json.getAsJsonObject(group);
                        if (jsonObject.has(name)) {
                            Config.load(item, jsonObject, name);
                            continue;
                        }
                    } else if (json.has(name)) {
                        Config.load(item, json, name);
                        continue;
                    }
                }
                group = field.getAnnotation(Group.class).value();
                name = field.getAnnotation(Name.class).config().isEmpty() ? field.getName() : field.getAnnotation(Name.class).config();
                name = name.toLowerCase().replace("_", "-").replace(" ", "-");
                if (json.has(group)) {
                    Config.load(item, json.getAsJsonObject(group), name);
                    continue;
                }
                Config.load(item, json, name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void load(ConfigItem item, JsonObject json, String path) {
        if (!json.has(path = path.toLowerCase().replace("_", "-"))) {
            return;
        }
        String val = switch (item.getType()) {
            default -> throw new MatchException(null, null);
            case ConfigItem.Type.BOOLEAN -> class_3518.method_15270((JsonObject)json, (String)path);
            case ConfigItem.Type.ENUM -> Enum.valueOf(item.getValue().getClass(), class_3518.method_15265((JsonObject)json, (String)path).toUpperCase());
            case ConfigItem.Type.INTEGER -> class_3518.method_15260((JsonObject)json, (String)path);
            case ConfigItem.Type.DOUBLE -> class_3518.method_34927((JsonObject)json, (String)path);
            case ConfigItem.Type.STRING -> class_3518.method_15265((JsonObject)json, (String)path);
            case ConfigItem.Type.UNKNOWN -> null;
        };
        item.setValue(val);
    }
}

