/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.config;

import gg.projecteden.titan.Titan;
import gg.projecteden.titan.config.annotations.Description;
import gg.projecteden.titan.config.annotations.Group;
import gg.projecteden.titan.config.annotations.Name;
import gg.projecteden.titan.config.annotations.OldConfig;
import gg.projecteden.titan.discord.RichPresence;
import gg.projecteden.titan.saturn.Saturn;
import gg.projecteden.titan.saturn.SaturnUpdater;
import gg.projecteden.titan.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ConfigItem<T> {
    private T value;
    private T defaultValue;
    @Group(value="Saturn")
    @Name(value="Update Instances", config="update-instances")
    @Description(value="When should Saturn be updated?")
    public static final ConfigItem<SaturnUpdater.Mode> SATURN_UPDATE_INSTANCES = new ConfigItem<SaturnUpdater.Mode>(SaturnUpdater.Mode.BOTH);
    @Group(value="Saturn")
    @Name(value="Enabled by Default", config="enabled-default")
    @Description(value="Should Saturn be enabled by default?")
    @OldConfig(value="saturn-enabled-default")
    public static final ConfigItem<Boolean> SATURN_ENABLED_DEFAULT = new ConfigItem<Boolean>(true);
    @Group(value="Saturn")
    @Name(value="Manage Status", config="manage-status")
    @OldConfig(value="saturn-manage-status")
    @Description(value="Should Titan enable and disable Saturn\nautomatically when playing on Project Eden?")
    public static final ConfigItem<Boolean> SATURN_MANAGE_STATUS = new ConfigItem<Boolean>(false);
    @Group(value="Saturn")
    @Name(value="Hard Reset", config="hard-reset")
    @OldConfig(value="saturn-hard-reset")
    @Description(value="Should Titan remove any local changes to Saturn on update?\n\nThis is a developer setting. Do not change unless you know what you're doing!")
    public static final ConfigItem<Boolean> SATURN_HARD_RESET = new ConfigItem<Boolean>(true);
    @Group(value="Utilities")
    @Name(value="Stop Entity Culling")
    @Description(value="Should Titan prevent ArmorStands and ItemFrames from\nun-rendering when inside a certain radius?\n\nThis prevents flickering and has no impact on performance.")
    public static final ConfigItem<Boolean> STOP_ENTITY_CULLING = new ConfigItem<Boolean>(true);
    @Group(value="Utilities")
    @Name(value="Stop Custom Block Flashing")
    @Description(value="Should Titan stop custom blocks from flashing\nwhen placing/breaking nearby blocks?")
    public static final ConfigItem<Boolean> STOP_CUSTOM_BLOCK_FLASHING = new ConfigItem<Boolean>(true);
    @Group(value="Utilities")
    @Name(value="Discord Rich Presence")
    @Description(value="Should we update your Discord Status while on Project Eden")
    public static final ConfigItem<Boolean> DISCORD_RICH_PRESENCE = new ConfigItem<Boolean>(Boolean.valueOf(true)){

        @Override
        public void onUpdate(Boolean newValue) {
            if (!Utils.isOnEden()) {
                return;
            }
            if (((Boolean)this.getValue()).booleanValue()) {
                RichPresence.start();
            } else {
                RichPresence.stop();
            }
        }
    };
    @Group(value="Utilities")
    @Name(value="Chat Channel Renderer")
    @Description(value="Should your current chat channel be rendered in chat")
    public static final ConfigItem<Boolean> CHAT_CHANNEL_RENDER = new ConfigItem<Boolean>(true);
    @Group(value="Backpacks")
    @Name(value="Show Backpack Previews")
    @Description(value="Should Titan render previews of Backpacks\nwhen hovered in your inventory?")
    public static final ConfigItem<Boolean> DO_BACKPACK_PREVIEWS = new ConfigItem<Boolean>(true);
    @Group(value="Backpacks")
    @Name(value="Backpack Previews Require Shift-Key")
    @Description(value="Should Backpack previews only show\nwhile the shift-key is pressed?")
    public static final ConfigItem<Boolean> PREVIEWS_REQUIRE_SHIFT = new ConfigItem<Boolean>(true);
    @Group(value="Backpacks")
    @Name(value="Use Backpack Colors")
    @Description(value="Should Backpack previews use the color of the Backpack?")
    public static final ConfigItem<Boolean> USE_BACKGROUND_COLORS = new ConfigItem<Boolean>(true);
    @Group(value="Developer")
    @Name(value="Debug")
    @Description(value="Enable debugging for Titan\nThis prints lots of information about the client")
    public static final ConfigItem<Boolean> DEBUG = new ConfigItem<Boolean>(Boolean.valueOf(false)){

        @Override
        public void onUpdate(Boolean newValue) {
            Titan.debug = newValue;
        }

        @Override
        public Boolean getValue() {
            return Titan.debug;
        }
    };
    @Group(value="Developer")
    @Name(value="Saturn Branch")
    @Description(value="Swap the branch Saturn is currently on\nThis will take some time to execute!")
    public static final ConfigItem<String> SATURN_BRANCH = new ConfigItem<String>("titan"){

        @Override
        public void onUpdate(String newValue) {
            Saturn.getUpdater().branch(newValue);
        }

        @Override
        public String getValue() {
            return Saturn.getUpdater().branch();
        }
    };

    public ConfigItem(T defaultValue) {
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    public Type getType() {
        if (this.value instanceof Boolean) {
            return Type.BOOLEAN;
        }
        if (this.value instanceof Enum) {
            return Type.ENUM;
        }
        if (this.value instanceof Integer) {
            return Type.INTEGER;
        }
        if (this.value instanceof Double) {
            return Type.DOUBLE;
        }
        if (this.value instanceof String) {
            return Type.STRING;
        }
        return Type.UNKNOWN;
    }

    public void onUpdate(T newValue) {
    }

    public static List<Field> getAllNonDeveloperOptions() {
        return Arrays.stream(ConfigItem.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType() == ConfigItem.class).filter(f -> f.isAnnotationPresent(Group.class) && !f.getAnnotation(Group.class).value().equals("Developer")).collect(Collectors.toList());
    }

    public static List<Field> getDeveloperOptions() {
        return Arrays.stream(ConfigItem.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType() == ConfigItem.class).filter(f -> f.isAnnotationPresent(Group.class) && f.getAnnotation(Group.class).value().equals("Developer")).collect(Collectors.toList());
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(T value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static enum Type {
        BOOLEAN,
        ENUM,
        INTEGER,
        DOUBLE,
        STRING,
        UNKNOWN;

    }
}

