/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.creative;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class CustomCreativeItem {
    String category;
    String item;

    public class_1799 getItemStack() {
        class_2487 nbt = this.getNbt();
        if (nbt == null) {
            return null;
        }
        if (!nbt.method_10545("id")) {
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)((String)nbt.method_10558("id").get())));
        class_1799 itemStack = new class_1799((class_1935)item);
        if (nbt.method_10545("count")) {
            itemStack.method_7939(((Integer)nbt.method_10550("count").get()).intValue());
        }
        if (nbt.method_10545("components")) {
            class_2487 components = (class_2487)nbt.method_10562("components").get();
            this.parseComponents(components, itemStack);
        }
        return itemStack;
    }

    private class_2487 getNbt() {
        try {
            return class_2522.method_67315((String)this.item);
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    private void parseComponents(class_2487 components, class_1799 itemStack) {
        if (components.method_10545("minecraft:custom_data")) {
            class_2487 customData = (class_2487)components.method_10562("minecraft:custom_data").get();
            itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
        }
        if (components.method_10545("minecraft:custom_name")) {
            class_2487 customName = (class_2487)components.method_10562("minecraft:custom_name").get();
            itemStack.method_57379(class_9334.field_49631, (Object)CustomCreativeItem.parseText((class_2520)customName));
        }
        if (components.method_10545("minecraft:lore")) {
            class_2499 lore = (class_2499)components.method_10554("minecraft:lore").get();
            itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(lore.stream().map(line -> CustomCreativeItem.parseText(line)).toList()));
        }
        if (components.method_10545("minecraft:item_model")) {
            String itemModel = (String)components.method_10558("minecraft:item_model").get();
            itemStack.method_57379(class_9334.field_54199, (Object)class_2960.method_60654((String)itemModel));
        }
        if (components.method_10545("minecraft:dyed_color")) {
            int dyedColor = (Integer)components.method_10550("minecraft:dyed_color").get();
            itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(dyedColor));
        }
    }

    public static class_2561 parseText(class_2520 tag) {
        return CustomCreativeItem.parseText(tag.toString());
    }

    public static class_2561 parseText(String jsonString) {
        if (jsonString.equals("\"\"")) {
            return class_2561.method_43473();
        }
        JsonElement element = JsonParser.parseString((String)jsonString);
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return class_2561.method_43470((String)element.getAsString());
        }
        JsonObject json = element.getAsJsonObject();
        String baseText = json.has("text") ? json.get("text").getAsString() : "";
        class_5250 result = class_2561.method_43470((String)baseText);
        if (json.has("extra") && json.get("extra").isJsonArray()) {
            JsonArray extras = json.getAsJsonArray("extra");
            for (JsonElement extraElement : extras) {
                JsonObject obj = extraElement.getAsJsonObject();
                String extraText = obj.get("text").getAsString();
                class_2583 style = class_2583.field_24360;
                if (obj.has("bold")) {
                    style = style.method_10982(Boolean.valueOf(obj.get("bold").getAsBoolean()));
                }
                if (obj.has("italic")) {
                    style = style.method_10978(Boolean.valueOf(obj.get("italic").getAsBoolean()));
                }
                if (obj.has("underlined")) {
                    style = style.method_30938(Boolean.valueOf(obj.get("underlined").getAsBoolean()));
                }
                if (obj.has("strikethrough")) {
                    style = style.method_36140(Boolean.valueOf(obj.get("strikethrough").getAsBoolean()));
                }
                if (obj.has("obfuscated")) {
                    style = style.method_36141(Boolean.valueOf(obj.get("obfuscated").getAsBoolean()));
                }
                if (obj.has("color")) {
                    String color = obj.get("color").getAsString();
                    if (color.startsWith("#")) {
                        int rgb = Integer.parseInt(color.substring(1), 16);
                        style = style.method_36139(rgb);
                    } else {
                        class_124 formatting = class_124.method_533((String)color);
                        if (formatting != null) {
                            style = style.method_10977(formatting);
                        }
                    }
                }
                result.method_10852((class_2561)class_2561.method_43470((String)extraText).method_10862(style));
            }
        }
        return result;
    }

    @Generated
    public CustomCreativeItem() {
    }

    @Generated
    public CustomCreativeItem(String category, String item) {
        this.category = category;
        this.item = item;
    }
}

