/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.creative;

import gg.projecteden.titan.Titan;
import gg.projecteden.titan.creative.CustomCreativeItem;
import gg.projecteden.titan.utils.NexusAPI;
import gg.projecteden.titan.utils.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7923;

public class CustomCreativeTabs {
    public static final Map<String, String> CATEGORY_PREFIXES = new HashMap<String, String>();
    public static final Map<String, class_1761> GROUPS = new HashMap<String, class_1761>();
    public static final Map<String, CustomCreativeItem[]> ITEMS = new HashMap<String, CustomCreativeItem[]>();

    public static void init(String title, CustomCreativeItem icon, int index) {
        String id = CustomCreativeTabs.toId(title);
        class_1761 group = CustomCreativeTabs.register(id, new class_1761.class_7913(index % 10 < 5 ? class_1761.class_7915.field_41049 : class_1761.class_7915.field_41050, index % 5).method_47321((class_2561)class_2561.method_43470((String)title)).method_47320(icon::getItemStack).method_47317((displayContext, entries) -> {
            if (!ITEMS.containsKey(id) || ITEMS.get(id) == null) {
                return;
            }
            for (CustomCreativeItem item : ITEMS.get(id)) {
                if (icon.getItemStack() == null) continue;
                entries.method_45417(item.getItemStack(), class_1761.class_7705.field_40191);
            }
        }).method_47324());
        GROUPS.put(id, group);
    }

    public static <T extends class_1761> T register(String name, T itemGroup) {
        return (T)((class_1761)class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)Titan.id(name), itemGroup));
    }

    public static void update() {
        ITEMS.clear();
        CustomCreativeItem[] items = NexusAPI.getItems();
        for (String id : GROUPS.keySet()) {
            ITEMS.put(id, (CustomCreativeItem[])Arrays.stream(items).filter(item -> CustomCreativeTabs.toId(item.category).equals(id)).toArray(CustomCreativeItem[]::new));
            class_1761 group = GROUPS.get(id);
            group.method_47306(new class_1761.class_8128(class_7699.method_45398((class_7696)class_7701.field_40177), true, null));
        }
    }

    public static void updateAsync() {
        new Thread(CustomCreativeTabs::update).start();
    }

    public static void clear() {
        ITEMS.clear();
        for (String id : GROUPS.keySet()) {
            class_1761 group = GROUPS.get(id);
            group.method_47306(new class_1761.class_8128(class_7699.method_45398((class_7696)class_7701.field_40177), true, null));
        }
    }

    public static void init() {
        CustomCreativeItem[] categories = NexusAPI.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            CATEGORY_PREFIXES.put(categories[i].category, String.valueOf((char)(97 + i % 26)));
            CustomCreativeTabs.init(categories[i].category, categories[i], i);
        }
        CustomCreativeTabs.update();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> CustomCreativeTabs.updateAsync());
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (!Utils.isOnEden()) {
                CustomCreativeTabs.clear();
            }
        });
    }

    public static String toId(String title) {
        return CATEGORY_PREFIXES.get(title) + "_" + title.toLowerCase().replace(" ", "_").replace(":", "");
    }
}

