/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.discord;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.activity.Activity;
import gg.projecteden.titan.Titan;
import gg.projecteden.titan.config.ConfigItem;
import gg.projecteden.titan.discord.PlayerStates;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;

public class RichPresence {
    static boolean disabled;
    private static CreateParams params;
    static Core core;
    static Activity mainActivity;
    static Activity tempActivity;
    static boolean started;
    static Map<UpdateType, Runnable> updateQueues;

    private static void update() {
        if (disabled) {
            return;
        }
        if (core == null) {
            return;
        }
        if (!ConfigItem.DISCORD_RICH_PRESENCE.getValue().booleanValue()) {
            return;
        }
        if (mainActivity != null || tempActivity != null) {
            RichPresence.runCallbacks();
        }
    }

    public static void start() {
        Titan.debug("Starting RPC");
        if (disabled) {
            return;
        }
        Titan.debug("Core was loading");
        if (!(core != null && core.isOpen() || RichPresence.tryCreateCore())) {
            return;
        }
        Titan.debug("Core is not null and open");
        if (started) {
            return;
        }
        Titan.debug("Not started");
        if (!ConfigItem.DISCORD_RICH_PRESENCE.getValue().booleanValue()) {
            return;
        }
        Titan.debug("RPC Enabled");
        if (PlayerStates.isVanished()) {
            return;
        }
        Titan.debug("Not vanished");
        mainActivity = RichPresence.generateActivity();
        if (mainActivity == null) {
            Titan.debug("Main activity is null");
            return;
        }
        Titan.debug("Setting details: " + PlayerStates.getWorldDetails());
        RichPresence.update(UpdateType.DETAILS, () -> mainActivity.setDetails(PlayerStates.getWorldDetails()));
        started = true;
    }

    public static void stop() {
        block6: {
            if (disabled) {
                return;
            }
            if (core == null || !core.isOpen()) {
                return;
            }
            try {
                if (tempActivity != null) {
                    tempActivity.close();
                }
                if (mainActivity != null) {
                    mainActivity.close();
                }
                tempActivity = null;
                mainActivity = null;
                core.close();
                core = null;
                params.close();
                params = null;
            }
            catch (Throwable throwable) {
                if (throwable.getMessage() == null) break block6;
                Titan.log(throwable.getMessage(), new Object[0]);
            }
        }
        started = false;
    }

    public static void resetTimestamp() {
        Titan.debug("Returning to main activity");
        RichPresence.update(UpdateType.TIMESTAMP, () -> {
            tempActivity = null;
        });
    }

    public static void setTimestamp() {
        Titan.debug("Switching to new activity for timestamp");
        tempActivity = RichPresence.generateActivity();
        if (tempActivity == null) {
            return;
        }
        RichPresence.update(UpdateType.TIMESTAMP, () -> {
            tempActivity.setDetails(mainActivity.getDetails());
            tempActivity.setState(mainActivity.getState());
        });
    }

    public static void updateWorld() {
        RichPresence.update(UpdateType.DETAILS, () -> mainActivity.setDetails(PlayerStates.getWorldDetails()));
    }

    public static void updateDetails(String details) {
        RichPresence.update(UpdateType.STATE, () -> mainActivity.setState(details == null ? "" : details));
    }

    public static Activity generateActivity() {
        if (disabled) {
            return null;
        }
        if (core == null) {
            return null;
        }
        Titan.debug("Generating activity");
        Activity activity = new Activity();
        activity.assets().setLargeImage("shield-circle");
        activity.assets().setLargeText("projecteden.gg");
        activity.timestamps().setStart(Instant.now());
        Titan.debug("Activity generated");
        return activity;
    }

    private static void runCallbacks() {
        block6: {
            if (disabled) {
                return;
            }
            if (core == null || !core.isOpen()) {
                return;
            }
            if (mainActivity == null) {
                return;
            }
            try {
                for (UpdateType type : UpdateType.values()) {
                    Runnable runnable = updateQueues.remove((Object)type);
                    if (runnable == null) continue;
                    runnable.run();
                }
                core.activityManager().updateActivity(tempActivity != null ? tempActivity : mainActivity);
                core.runCallbacks();
            }
            catch (Throwable throwable) {
                if (throwable.getMessage() == null) break block6;
                Titan.log(throwable.getMessage(), new Object[0]);
            }
        }
    }

    private static void initEvents() {
        AtomicInteger tick = new AtomicInteger(0);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (tick.getAndIncrement() % 5 == 0) {
                tick.set(0);
                new Thread(RichPresence::update).start();
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> RichPresence.stop());
    }

    public static void init() {
        try {
            Core.initDownload();
            if (RichPresence.tryCreateCore()) {
                RichPresence.initEvents();
            }
        }
        catch (Exception ex) {
            disabled = true;
            Titan.log("There was an exception while initialize Discord Rich Presence: " + ex.getMessage(), new Object[0]);
            ex.printStackTrace();
        }
    }

    private static boolean tryCreateCore() {
        try {
            CreateParams params = new CreateParams();
            params.setClientID(1207154982076555274L);
            params.setFlags(new CreateParams.Flags[]{CreateParams.Flags.NO_REQUIRE_DISCORD});
            RichPresence.params = params;
            core = new Core(params);
            return true;
        }
        catch (Exception ex) {
            disabled = true;
            Titan.log("There was an exception while initialize Discord Rich Presence: " + ex.getMessage(), new Object[0]);
            ex.printStackTrace();
            return false;
        }
    }

    private static void update(UpdateType type, Runnable runnable) {
        updateQueues.put(type, runnable);
    }

    static {
        updateQueues = new HashMap<UpdateType, Runnable>();
    }

    private static enum UpdateType {
        STATE,
        DETAILS,
        TIMESTAMP;

    }
}

