/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.mixin;

import gg.projecteden.titan.config.ConfigItem;
import gg.projecteden.titan.discord.PlayerStates;
import gg.projecteden.titan.utils.Utils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_408.class})
public class ChatScreenMixin
extends class_437 {
    @Shadow
    protected class_342 field_2382;
    @Unique
    private static final List<String> CHANNEL_ALIASES = Arrays.asList("/ch", "/chat", "/channel");
    @Unique
    private static final List<String> MESSAGE_ALIASES = Arrays.asList("/message", "/m", "/msg", "/w", "/whisper", "/t", "/tell", "/pm", "/dm", "/r", "/reply");

    protected ChatScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!Utils.isOnEden()) {
            return;
        }
        if (!ConfigItem.CHAT_CHANNEL_RENDER.getValue().booleanValue()) {
            return;
        }
        PlayerStates.ChatChannel channel = this.detectQuickMessage();
        if (channel == null) {
            channel = PlayerStates.getChannel();
        }
        if (channel == PlayerStates.ChatChannel.UNKNOWN) {
            return;
        }
        context.method_25294(0, this.field_22790 - 14, 2, this.field_22790 - 2, channel.getColor());
    }

    @Unique
    private PlayerStates.ChatChannel detectQuickMessage() {
        String chat = this.field_2382.method_1882().trim();
        if (chat.isBlank()) {
            return null;
        }
        for (String prefix : CHANNEL_ALIASES) {
            String[] parts;
            if (chat.startsWith(prefix + " qm ") && (parts = chat.split(" ", 4)).length >= 3) {
                String target = parts[2];
                return Arrays.stream(PlayerStates.ChatChannel.values()).filter(channel -> target.equals(channel.getShortcut()) || target.equalsIgnoreCase(channel.name())).findFirst().orElse(null);
            }
            if (!chat.startsWith(prefix + " ") || (parts = chat.split(" ", 3)).length != 3) continue;
            String target = parts[1];
            return Arrays.stream(PlayerStates.ChatChannel.values()).filter(channel -> target.equals(channel.getShortcut()) || target.equalsIgnoreCase(channel.name())).findFirst().orElse(null);
        }
        for (String prefix : MESSAGE_ALIASES) {
            if (!chat.startsWith(prefix + " ")) continue;
            return PlayerStates.ChatChannel.PRIVATE;
        }
        return null;
    }
}

