/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.saturn;

import gg.projecteden.titan.Titan;
import gg.projecteden.titan.network.ServerClientMessaging;
import gg.projecteden.titan.network.serverbound.Versions;
import gg.projecteden.titan.saturn.SaturnUpdater;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_3283;

public class Saturn {
    private static final SaturnUpdater updater = SaturnUpdater.GIT;
    public static SaturnUpdater.Env env = SaturnUpdater.Env.PROD;
    public static final Path PATH = FabricLoader.getInstance().getGameDir().resolve("resourcepacks/Saturn");
    public static final Path DOT_GIT_PATH = PATH.resolve(".git");
    public static List<Runnable> queuedProcesses = new ArrayList<Runnable>();

    public static boolean update() {
        try {
            if (!Saturn.isInstalled()) {
                Titan.log("Installing Saturn", new Object[0]);
                Titan.log(updater.install(), new Object[0]);
            } else if (updater.checkForUpdates()) {
                Titan.log("Updating Saturn", new Object[0]);
                Titan.log(updater.update(), new Object[0]);
            } else {
                Titan.log("Not updating as Saturn is already up-to-date", new Object[0]);
                return false;
            }
            ServerClientMessaging.send(new Versions());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isInstalled() {
        return PATH.toFile().exists() && DOT_GIT_PATH.toFile().exists();
    }

    public static String version() {
        if (!Saturn.isInstalled()) {
            return null;
        }
        return updater.version();
    }

    public static String shortVersion() {
        String version = Saturn.version();
        if (version == null) {
            return null;
        }
        return version.substring(0, Math.min(7, version.length()));
    }

    public static boolean checkForUpdates() {
        return updater.checkForUpdates();
    }

    public static CompletableFuture<Boolean> checkForUpdatesAsync() {
        return updater.checkForUpdatesAsync();
    }

    public static void queueProcess(Runnable runnable) {
        queuedProcesses.add(runnable);
    }

    public static void enable() {
        class_3283 manager = class_310.method_1551().method_1520();
        if (!manager.method_29210().contains("file/Saturn")) {
            ArrayList<String> packs = new ArrayList<String>(manager.method_29210());
            packs.add("file/Saturn");
            manager.method_14447(packs);
            class_310.method_1551().method_1521();
        }
    }

    public static void disable() {
        class_3283 manager = class_310.method_1551().method_1520();
        if (manager.method_29210().contains("file/Saturn")) {
            ArrayList packs = new ArrayList(manager.method_29210());
            packs.remove("file/Saturn");
            manager.method_14447(packs);
            class_310.method_1551().method_1521();
        }
    }

    @Generated
    public static SaturnUpdater getUpdater() {
        return updater;
    }
}

