/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.saturn;

import gg.projecteden.titan.Titan;
import gg.projecteden.titan.config.ConfigItem;
import gg.projecteden.titan.saturn.Saturn;
import gg.projecteden.titan.update.GitResponse;
import gg.projecteden.titan.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import joptsimple.internal.Strings;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;

public enum SaturnUpdater {
    GIT{
        final String REMOTE_NAME = "https";
        final String REMOTE_URI = "https://github.com/ProjectEdenGG/Saturn.git";
        boolean updateAvailable;

        @Override
        public String version() {
            String string;
            block17: {
                Git git = this.git();
                try {
                    string = git.getRepository().findRef("HEAD").getObjectId().getName().substring(0, 7);
                    if (git == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        String string2;
                        block18: {
                            ex.printStackTrace();
                            if (!ConfigItem.SATURN_HARD_RESET.getValue().booleanValue()) {
                                return "Unknown";
                            }
                            Titan.log("Attempting to reinstall...", new Object[0]);
                            Titan.log(this.install(), new Object[0]);
                            Git git2 = this.git();
                            try {
                                string2 = git2.getRepository().findRef("HEAD").getObjectId().getName().substring(0, 7);
                                if (git2 == null) break block18;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    if (git2 != null) {
                                        try {
                                            git2.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                    }
                                    throw throwable3;
                                }
                                catch (Exception ex2) {
                                    ex2.printStackTrace();
                                    return "Unknown";
                                }
                            }
                            git2.close();
                        }
                        return string2;
                    }
                }
                git.close();
            }
            return string;
        }

        @Override
        public String install() {
            String string;
            block9: {
                if (Saturn.PATH.toFile().exists()) {
                    FileUtils.deleteDirectory((File)Saturn.PATH.toFile());
                }
                Git git = this.cloneCommand().call();
                try {
                    string = git.toString();
                    if (git == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        Titan.log("An error occurred while installing Saturn:", new Object[0]);
                        ex.printStackTrace();
                        return ex.getMessage();
                    }
                }
                git.close();
            }
            return string;
        }

        protected CloneCommand cloneCommand() {
            return Git.cloneRepository().setBranchesToClone(List.of("refs/heads/titan")).setBranch("titan").setURI("https://github.com/ProjectEdenGG/Saturn.git").setDirectory(this.getResourcePackFolder().resolve("Saturn").toFile());
        }

        @NotNull
        private Path getResourcePackFolder() {
            return FabricLoader.getInstance().getGameDir().resolve("resourcepacks");
        }

        @Override
        public String update() {
            String string;
            block11: {
                Titan.log("Updating Saturn via jgit", new Object[0]);
                Git git = this.git();
                try {
                    if (ConfigItem.SATURN_HARD_RESET.getValue().booleanValue()) {
                        BranchConfig branchConfig = new BranchConfig((Config)git.getRepository().getConfig(), git.getRepository().getBranch());
                        String ref = branchConfig.getRemote() + "/" + branchConfig.getMerge().substring("refs/heads/".length());
                        Titan.log("Using ref " + ref, new Object[0]);
                        git.reset().setMode(ResetCommand.ResetType.HARD).setRef(ref).call();
                    }
                    this.updateAvailable = false;
                    List remotes = git.remoteList().call();
                    if (remotes.stream().noneMatch(config -> config.getName().equals("https"))) {
                        git.remoteAdd().setName("https").setUri(new URIish("https://github.com/ProjectEdenGG/Saturn.git")).call();
                    } else {
                        git.remoteSetUrl().setRemoteName("https").setRemoteUri(new URIish("https://github.com/ProjectEdenGG/Saturn.git")).call();
                    }
                    string = git.pull().setRemote("https").setRebase(true).call().toString();
                    if (git == null) break block11;
                }
                catch (Throwable throwable) {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                git.close();
            }
            return string;
        }

        @NotNull
        private Git git() {
            return new Git(((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.getResourcePackFolder().resolve("Saturn").resolve(".git").toFile())).readEnvironment()).findGitDir()).build());
        }

        @Override
        public boolean checkForUpdates() {
            if (this.updateAvailable) {
                return true;
            }
            try (Git git = this.git();){
                String commitVersion = Utils.getGitResponse("Saturn/commits/" + git.getRepository().getBranch(), GitResponse.Saturn.class).getSha();
                String saturnVersion = Saturn.version();
                this.updateAvailable = commitVersion != null && saturnVersion != null && !commitVersion.startsWith(saturnVersion) || Strings.isNullOrEmpty((String)saturnVersion);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.updateAvailable;
        }

        @Override
        public CompletableFuture<Boolean> checkForUpdatesAsync() {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            if (this.updateAvailable) {
                return CompletableFuture.completedFuture(true);
            }
            new Thread(() -> {
                try (Git git = this.git();){
                    String commitVersion = Utils.getGitResponse("Saturn/commits/" + git.getRepository().getBranch(), GitResponse.Saturn.class).getSha();
                    String saturnVersion = Saturn.version();
                    future.complete(commitVersion != null && saturnVersion != null && !commitVersion.startsWith(saturnVersion) || Strings.isNullOrEmpty((String)saturnVersion));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            return future;
        }

        @Override
        public void branch(String branch) {
            if (this.branch().endsWith(branch)) {
                return;
            }
            Titan.log("Checking out to " + branch, new Object[0]);
            try (Git git = this.git();){
                boolean branchExistsLocally;
                for (String remote : git.getRepository().getRemoteNames()) {
                    Titan.log("Fetching from remote: " + remote, new Object[0]);
                    git.fetch().setRemote(remote).setRefSpecs(new String[]{"+refs/heads/*:refs/remotes/" + remote + "/*"}).call();
                }
                boolean bl = branchExistsLocally = git.getRepository().findRef(branch) != null;
                if (branchExistsLocally) {
                    Titan.log("Branch '" + branch + "' exists locally. Checking it out...", new Object[0]);
                    Saturn.queueProcess(() -> {
                        try {
                            git.checkout().setName(branch).call();
                            class_310.method_1551().method_1521();
                        }
                        catch (Exception e) {
                            Titan.log("Failed to checkout " + branch, new Object[0]);
                            e.printStackTrace();
                        }
                    });
                } else {
                    Set remotes = git.getRepository().getRemoteNames();
                    String foundRemote = null;
                    for (String remote : remotes) {
                        List refs = git.lsRemote().setRemote(remote).setHeads(true).call().stream().toList();
                        boolean branchExists = refs.stream().anyMatch(ref -> ref.getName().endsWith(branch));
                        if (!branchExists) continue;
                        foundRemote = remote;
                        break;
                    }
                    if (foundRemote == null) {
                        Titan.log("Branch '" + branch + "' does not exist on any remote!", new Object[0]);
                        return;
                    }
                    Titan.log("Branch found on remote: " + foundRemote, new Object[0]);
                    String remoteBranchRef = "refs/remotes/" + foundRemote + "/" + branch;
                    if (git.getRepository().exactRef(remoteBranchRef) == null) {
                        Titan.log("Remote branch found but not tracked locally, attempting to fetch explicitly...", new Object[0]);
                        git.fetch().setRemote(foundRemote).setRefSpecs(new String[]{"+refs/heads/" + branch + ":refs/remotes/" + foundRemote + "/" + branch}).call();
                    }
                    if (git.getRepository().exactRef(remoteBranchRef) == null) {
                        Titan.log("Failed to fetch branch '" + branch + "' from remote '" + foundRemote + "'", new Object[0]);
                        return;
                    }
                    Titan.log("Creating and checking out branch '" + branch + "' from remote '" + foundRemote + "'", new Object[0]);
                    Saturn.queueProcess(() -> {
                        try {
                            git.checkout().setCreateBranch(true).setForceRefUpdate(true).setName(branch).setStartPoint(remoteBranchRef).call();
                            class_310.method_1551().method_1521();
                        }
                        catch (Exception e) {
                            Titan.log("Could not checkout to new branch " + branch, new Object[0]);
                            e.printStackTrace();
                        }
                    });
                }
                class_310.method_1551().method_1521();
            }
            catch (Exception e) {
                Titan.log("Error: " + e.getMessage(), new Object[0]);
            }
        }

        @Override
        public String branch() {
            String string;
            block8: {
                Git git = this.git();
                try {
                    string = git.getRepository().getBranch();
                    if (git == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return "Unknown";
                    }
                }
                git.close();
            }
            return string;
        }
    };


    public abstract String version();

    public abstract String install();

    public abstract String update();

    public abstract void branch(String var1);

    public abstract String branch();

    public abstract boolean checkForUpdates();

    public abstract CompletableFuture<Boolean> checkForUpdatesAsync();

    public static enum Env {
        PROD{

            @Override
            public String getSuffix() {
                return "";
            }
        }
        ,
        TEST;


        public String getSuffix() {
            return "-" + this.name();
        }
    }

    public static enum Mode {
        START_UP,
        TEXTURE_RELOAD,
        BOTH;

    }
}

