/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.update;

import com.google.gson.Gson;
import gg.projecteden.titan.Titan;
import gg.projecteden.titan.update.ModrinthVersion;
import gg.projecteden.titan.update.UpdateStatus;
import gg.projecteden.titan.utils.Utils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.minecraft.class_310;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class TitanUpdater {
    public static UpdateStatus updateStatus = UpdateStatus.NONE;
    public static Date buildDate;
    public static final String mcVersion;

    public static void checkForUpdates() {
        ModrinthVersion[] modrinthVersionsResponse;
        TitanUpdater.updateBuildDate();
        Titan.log("Checking for Modrinth update", new Object[0]);
        try {
            modrinthVersionsResponse = TitanUpdater.getModrinthVersions();
        }
        catch (Exception ignore) {
            return;
        }
        if (modrinthVersionsResponse == null) {
            return;
        }
        List<ModrinthVersion> modrinthVersions = Arrays.stream(modrinthVersionsResponse).filter(version -> Arrays.asList(version.getGame_versions()).contains(mcVersion)).toList();
        Titan.log("Found " + modrinthVersions.size() + " possible version" + (modrinthVersions.size() == 1 ? "" : "s"), new Object[0]);
        ModrinthVersion modrinthVersion = modrinthVersions.stream().max(Comparator.comparing(ModrinthVersion::getDatePublished)).orElse(null);
        if (modrinthVersion == null) {
            return;
        }
        if (modrinthVersion.getVersion_number().equals(Titan.version())) {
            return;
        }
        if (modrinthVersion.getDatePublished().before(buildDate)) {
            return;
        }
        Titan.log("Found Modrinth update!", new Object[0]);
        updateStatus = UpdateStatus.AVAILABLE;
    }

    private static void updateBuildDate() {
        if (buildDate == null) {
            String date = Utils.getManifestAttribute("Build-Timestamp");
            buildDate = Utils.ISODate(date);
        }
    }

    private static ModrinthVersion[] getModrinthVersions() {
        ModrinthVersion[] modrinthVersionArray;
        block8: {
            int timeout = 5000;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            CloseableHttpClient client = HttpClientBuilder.create().build();
            try {
                HttpGet request = new HttpGet("https://api.modrinth.com/v2/project/f44hEoWP/version");
                request.setConfig(requestConfig);
                request.addHeader("Accept", "application/json");
                request.addHeader("Authorization", "mrp_oyEJu5NksuJpOuRNQmHoisTES9DFdMMzATX8gFhySvNqVbHcHEzM8WD9Za7V");
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                modrinthVersionArray = (ModrinthVersion[])new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), ModrinthVersion[].class);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Titan.log("Error while getting Modrinth version", new Object[0]);
                    e.printStackTrace();
                    return new ModrinthVersion[0];
                }
            }
            client.close();
        }
        return modrinthVersionArray;
    }

    static {
        mcVersion = class_310.method_1551().method_1515();
    }
}

