/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.utils;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTextureView;
import gg.projecteden.titan.Titan;
import gg.projecteden.titan.mixin.DrawContextMixin;
import gg.projecteden.titan.utils.TexturedRectGUIElement;
import lombok.Generated;
import net.minecraft.class_1049;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class InventoryOverlay {
    public static final class_2960 TEXTURE_54 = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();

    public static void renderInventoryBackground(class_332 context, InventoryRenderType type, int x, int y, int color, class_310 mc) {
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int rows = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
        };
        int h1 = 61 + rows * 18;
        int h2 = 54 + rows * 18;
        InventoryOverlay.renderInventoryBackground(context, x, y, h1, h2, color, mc);
    }

    public static void renderInventoryBackground(class_332 context, int x, int y, int h1, int h2, int color, class_310 mc) {
        class_1049 tex = (class_1049)mc.method_1531().method_4619(TEXTURE_54);
        if (tex == null) {
            return;
        }
        GpuTextureView gpuTextureView = tex.method_71659();
        if (gpuTextureView == null) {
            return;
        }
        InventoryOverlay.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, h1, color);
        InventoryOverlay.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 7, 0, 169, 7, color);
        InventoryOverlay.drawTexturedRectBatched(context, gpuTextureView, x + 169, y + 7, 169, 107, 7, h1 - 1, color);
        InventoryOverlay.drawTexturedRectBatched(context, gpuTextureView, x, y + h1, 0, 215, 180, 7, color);
        InventoryOverlay.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 162, h2, color);
    }

    public static void drawTexturedRectBatched(class_332 drawContext, GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height, int argb) {
        InventoryOverlay.addSimpleElement(drawContext, new TexturedRectGUIElement(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), x, y, u, v, width, height, argb, InventoryOverlay.peekLastScissor(drawContext)));
    }

    public static void addSimpleElement(class_332 drawContext, class_11244 simpleElement) {
        ((DrawContextMixin)drawContext).getRenderState().method_70919(simpleElement);
    }

    public static class_8030 peekLastScissor(class_332 drawContext) {
        return ((DrawContextMixin)drawContext).getScissorStack().method_70863();
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type) {
        int totalSlots = Integer.parseInt(type.name().replace("FIXED_", ""));
        InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
        InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
        InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
        int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
        InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
        InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc, class_332 drawContext) {
        int slots = inv.method_5439();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        Titan.debug("RenderInventoryStacks: " + maxSlots);
        int slot = startSlot;
        while (slot < maxSlots) {
            class_1799 stack = inv.method_5438(slot).method_7972();
            if (!stack.method_7960()) {
                InventoryOverlay.renderStackAt(drawContext, stack, x, y, 1.0f, mc);
            }
            x += 18;
            if (++slot % slotsPerRow == 0) {
                Titan.debug("Rendering on next row");
                x = startX;
                y += 18;
                continue;
            }
            Titan.debug("Rendering on next column");
        }
    }

    public static void renderStackAt(class_332 drawContext, class_1799 stack, float x, float y, float scale, class_310 mc) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        drawContext.method_51427(stack.method_7972(), 0, 0);
        drawContext.method_51431(mc.field_1772, stack.method_7972(), 0, 0);
        matrixStack.popMatrix();
    }

    public static enum InventoryRenderType {
        FIXED_27(27),
        FIXED_36(36),
        FIXED_45(45),
        FIXED_54(54);

        final int maxSlots;

        @Generated
        public int getMaxSlots() {
            return this.maxSlots;
        }

        @Generated
        private InventoryRenderType(int maxSlots) {
            this.maxSlots = maxSlots;
        }
    }

    public static class InventoryProperties {
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }
}

