/*
 * Decompiled with CFR 0.152.
 */
package gg.projecteden.titan.utils;

import com.google.gson.Gson;
import gg.projecteden.titan.Titan;
import gg.projecteden.titan.creative.CustomCreativeItem;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.class_310;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class NexusAPI {
    public static final int TIMEOUT = 5000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T get(String endpoint, Class<T> returnType) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet request = new HttpGet("https://mcapi.projecteden.gg/" + endpoint);
            request.setConfig(requestConfig);
            request.addHeader("Accept", "application/json");
            request.setHeader("Accept-Charset", "UTF-8");
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            Object object = new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8), returnType);
            return (T)object;
        }
        catch (Exception e) {
            Titan.log("Error while getting Custom Blocks", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    public static CustomCreativeItem[] getItems() {
        CustomCreativeItem[] items = NexusAPI.get("titan/creative/items/" + NexusAPI.getUUID(), CustomCreativeItem[].class);
        if (items == null) {
            return new CustomCreativeItem[0];
        }
        return items;
    }

    public static CustomCreativeItem[] getCategories() {
        CustomCreativeItem[] categories = NexusAPI.get("titan/creative/categories/" + NexusAPI.getUUID(), CustomCreativeItem[].class);
        if (categories == null) {
            return new CustomCreativeItem[0];
        }
        return categories;
    }

    private static String getUUID() {
        UUID uuid = class_310.method_1551().method_1548().method_44717();
        if (uuid == null) {
            return UUID.randomUUID().toString();
        }
        return uuid.toString();
    }
}

