/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class AbandonedQuarry
extends RuinedStructures999.Structure {
    private final Random rand = new Random();
    private final int quarryRadius = 15;
    private final int quarryDepth = 20;

    public AbandonedQuarry(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(16);
            int highestY = world.getHighestBlockYAt(baseX, baseZ = chunk.getZ() * 16 + this.rand.nextInt(16));
            if (highestY < 70) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            Biome biome = world.getBlockAt(baseX, highestY, baseZ).getBiome();
            if (!this.getAllowedBiomes().isEmpty() && !this.getAllowedBiomes().contains(biome)) continue;
            int flatEnough = 0;
            for (int dx = -5; dx <= 5; ++dx) {
                for (int dz = -5; dz <= 5; ++dz) {
                    if (Math.abs(world.getHighestBlockYAt(baseX + dx, baseZ + dz) - highestY) >= 3) continue;
                    ++flatEnough;
                }
            }
            if (flatEnough <= 80) continue;
            return base;
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int y = baseY; y > baseY - 20; --y) {
            double currentRadius = 15.0 * ((double)(y - (baseY - 20)) / 20.0);
            currentRadius = Math.max(4.5, currentRadius);
            for (int x = -15; x <= 15; ++x) {
                for (int z = -15; z <= 15; ++z) {
                    if (!((double)(x * x + z * z) <= currentRadius * currentRadius)) continue;
                    Block block = world.getBlockAt(baseX + x, y, baseZ + z);
                    if (y == baseY) {
                        if (!(this.rand.nextDouble() < 0.1)) continue;
                        block.setType(Material.GRAVEL);
                        continue;
                    }
                    if (this.rand.nextDouble() < 0.015) {
                        block.setType(this.rand.nextBoolean() ? Material.COAL_ORE : Material.IRON_ORE);
                        continue;
                    }
                    if (this.rand.nextDouble() < 0.1) {
                        block.setType(this.rand.nextBoolean() ? Material.GRAVEL : Material.ANDESITE);
                        continue;
                    }
                    if (y > baseY - 20 + 2) {
                        block.setType(Material.STONE);
                        continue;
                    }
                    block.setType(Material.AIR);
                }
            }
        }
        int floorY = baseY - 20 + 1;
        for (int x = -15; x <= 15; ++x) {
            for (int z = -15; z <= 15; ++z) {
                if (!((double)(x * x + z * z) <= Math.pow(4.5, 2.0)) || !(this.rand.nextDouble() < 0.2)) continue;
                world.getBlockAt(baseX + x, floorY, baseZ + z).setType(this.rand.nextBoolean() ? Material.COBBLESTONE : Material.GRAVEL);
            }
        }
        this.buildOverseerHut(new Location(world, (double)(baseX + 15 - 2), (double)baseY, (double)baseZ));
        this.buildScaffolding(new Location(world, (double)(baseX - 15 + 1), (double)(baseY - 2), (double)(baseZ + 5)));
        this.placeLoot(base);
    }

    private void buildOverseerHut(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                world.getBlockAt(x + i, y - 1, z + j).setType(Material.COBBLESTONE);
                for (int k = 0; k < 3; ++k) {
                    if (i != 0 && i != 4 && j != 0 && j != 4 || !(this.rand.nextDouble() > 0.2)) continue;
                    world.getBlockAt(x + i, y + k, z + j).setType(Material.OAK_PLANKS);
                }
                if (!(this.rand.nextDouble() > 0.3)) continue;
                world.getBlockAt(x + i, y + 2, z + j).setType(Material.OAK_SLAB);
            }
        }
        world.getBlockAt(x + 2, y, z).setType(Material.AIR);
        world.getBlockAt(x + 2, y + 1, z).setType(Material.AIR);
        world.getBlockAt(x + 1, y, z + 1).setType(Material.CRAFTING_TABLE);
        world.getBlockAt(x + 3, y, z + 1).setType(Material.FURNACE);
        Block chestBlock = world.getBlockAt(x + 1, y, z + 3);
        chestBlock.setType(Material.CHEST);
        if (chestBlock.getState() instanceof Chest) {
            RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
        }
    }

    private void buildScaffolding(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (int i = 0; i < 15; ++i) {
            if (this.rand.nextDouble() > 0.1) {
                world.getBlockAt(x, y - i, z).setType(Material.OAK_LOG);
            }
            if (this.rand.nextDouble() > 0.4) {
                world.getBlockAt(x + 1, y - i, z).setType(Material.OAK_FENCE);
            }
            if (!(this.rand.nextDouble() > 0.4)) continue;
            world.getBlockAt(x - 1, y - i, z).setType(Material.OAK_FENCE);
        }
    }

    private void placeLoot(Location base) {
        int rY;
        int rZ;
        int rX;
        int i;
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (i = 0; i < 2 + this.rand.nextInt(2); ++i) {
            rX = baseX + this.rand.nextInt(30) - 15;
            rZ = baseZ + this.rand.nextInt(30) - 15;
            rY = baseY - 20 + 2;
            Block barrelBlock = world.getBlockAt(rX, rY, rZ);
            barrelBlock.setType(Material.BARREL);
            if (!(barrelBlock.getState() instanceof Barrel)) continue;
            RuinedStructures999.plugin.addChest(barrelBlock.getLocation(), this.getName());
        }
        for (i = 0; i < 1 + this.rand.nextInt(2); ++i) {
            rX = baseX + this.rand.nextInt(30) - 15;
            rZ = baseZ + this.rand.nextInt(30) - 15;
            rY = baseY - this.rand.nextInt(15);
            Block spawnerBlock = world.getBlockAt(rX, rY, rZ);
            spawnerBlock.setType(Material.SPAWNER);
            BlockState blockState = spawnerBlock.getState();
            if (!(blockState instanceof CreatureSpawner)) continue;
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(this.rand.nextBoolean() ? EntityType.CAVE_SPIDER : EntityType.SKELETON);
            spawner.update();
        }
    }
}

