/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.EntityType;

public class BanditCamp
extends RuinedStructures999.Structure {
    private final Random rand = new Random();

    public BanditCamp(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(5);
            int highestY = world.getHighestBlockYAt(baseX + 6, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(5)) + 6);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            Biome biome = world.getBlockAt(baseX + 6, highestY, baseZ + 6).getBiome();
            if (!this.getAllowedBiomes().isEmpty() && !this.getAllowedBiomes().contains(biome)) continue;
            return base;
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        Block spawnerBlock = world.getBlockAt(baseX + 6, baseY - 1, baseZ + 6);
        spawnerBlock.setType(Material.SPAWNER);
        BlockState blockState = spawnerBlock.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(EntityType.PILLAGER);
            spawner.update();
        }
        world.getBlockAt(baseX + 6, baseY, baseZ + 6).setType(Material.CAMPFIRE);
        this.buildWagon(new Location(world, (double)baseX, (double)baseY, (double)(baseZ + 2)));
        this.buildWagon(new Location(world, (double)(baseX + 8), (double)baseY, (double)(baseZ + 8)));
        this.buildTent(new Location(world, (double)(baseX + 8), (double)baseY, (double)baseZ), Material.RED_WOOL);
        this.buildTent(new Location(world, (double)(baseX + 2), (double)baseY, (double)(baseZ + 8)), Material.BLUE_WOOL);
        this.placeBarrelStack(new Location(world, (double)(baseX + 2), (double)baseY, (double)(baseZ + 2)));
        this.placeBarrelStack(new Location(world, (double)(baseX + 10), (double)baseY, (double)(baseZ + 6)));
    }

    private void buildWagon(Location loc) {
        int i;
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        world.getBlockAt(x, y - 1, z - 1).setType(Material.OAK_LOG);
        world.getBlockAt(x + 3, y - 1, z - 1).setType(Material.OAK_LOG);
        world.getBlockAt(x, y - 1, z + 2).setType(Material.OAK_LOG);
        world.getBlockAt(x + 3, y - 1, z + 2).setType(Material.OAK_LOG);
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                world.getBlockAt(x + i, y, z + j).setType(Material.OAK_SLAB);
            }
        }
        for (i = 0; i < 4; ++i) {
            world.getBlockAt(x + i, y, z - 1).setType(Material.OAK_FENCE);
            world.getBlockAt(x + i, y, z + 3).setType(Material.OAK_FENCE);
        }
        world.getBlockAt(x - 1, y, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x - 1, y, z + 1).setType(Material.OAK_FENCE);
        world.getBlockAt(x + 4, y, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x + 4, y, z + 1).setType(Material.OAK_FENCE);
        Block seat = world.getBlockAt(x - 1, y, z + 2);
        seat.setType(Material.OAK_STAIRS);
        Stairs stairsData = (Stairs)seat.getBlockData();
        stairsData.setFacing(BlockFace.EAST);
        seat.setBlockData((BlockData)stairsData);
    }

    private void buildTent(Location loc, Material woolColor) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        world.getBlockAt(x, y, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x + 3, y, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x, y + 1, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x + 3, y + 1, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x + 1, y + 2, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x + 2, y + 2, z).setType(Material.OAK_FENCE);
        world.getBlockAt(x, y + 2, z).setType(woolColor);
        world.getBlockAt(x + 3, y + 2, z).setType(woolColor);
        world.getBlockAt(x + 1, y + 3, z).setType(woolColor);
        world.getBlockAt(x + 2, y + 3, z).setType(woolColor);
    }

    private void placeBarrelStack(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        int height = 1 + this.rand.nextInt(3);
        for (int i = 0; i < height; ++i) {
            Block barrelBlock = world.getBlockAt(x, y + i, z);
            barrelBlock.setType(Material.BARREL);
            if (!(barrelBlock.getState() instanceof Barrel)) continue;
            RuinedStructures999.plugin.addChest(barrelBlock.getLocation(), this.getName());
        }
    }
}

