/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;

public class HauntedGraveyard
extends RuinedStructures999.Structure {
    private final Random rand = new Random();

    public HauntedGraveyard(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            Location base;
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(16);
            int highestY = world.getHighestBlockYAt(baseX, baseZ = chunk.getZ() * 16 + this.rand.nextInt(16));
            if (highestY < 63 || !this.isFlatEnough(base = new Location(world, (double)baseX, (double)highestY, (double)baseZ), 15, 3)) continue;
            Biome biome = world.getBiome(baseX, highestY, baseZ);
            if (!this.getAllowedBiomes().contains(biome)) continue;
            return base;
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        int size = 15;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                for (int y = 0; y < 10; ++y) {
                    world.getBlockAt(baseX + x, baseY + y, baseZ + z).setType(Material.AIR);
                }
                Material groundMat = this.rand.nextDouble() < 0.3 ? Material.PODZOL : (this.rand.nextDouble() < 0.5 ? Material.COARSE_DIRT : Material.GRASS_BLOCK);
                world.getBlockAt(baseX + x, baseY - 1, baseZ + z).setType(groundMat);
            }
        }
        this.buildPerimeter(world, baseX, baseY, baseZ, size);
        ArrayList<Location> graveLocations = new ArrayList<Location>();
        for (int i = 0; i < 15 + this.rand.nextInt(10); ++i) {
            int gZ;
            int gX = baseX + this.rand.nextInt(size * 2) - size;
            Location graveLoc = new Location(world, (double)gX, (double)baseY, (double)(gZ = baseZ + this.rand.nextInt(size * 2) - size));
            if (!(graveLoc.distance(base) > 5.0)) continue;
            this.buildGrave(world, graveLoc);
            graveLocations.add(graveLoc);
        }
        if (!graveLocations.isEmpty()) {
            Location hiddenGrave = (Location)graveLocations.get(this.rand.nextInt(graveLocations.size()));
            Block spawnerBlock = world.getBlockAt(hiddenGrave.getBlockX(), hiddenGrave.getBlockY() - 3, hiddenGrave.getBlockZ());
            spawnerBlock.setType(Material.SPAWNER);
            BlockState blockState = spawnerBlock.getState();
            if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                spawner.setSpawnedType(EntityType.ZOMBIE);
                spawner.update();
            }
            Block coffinBlock = world.getBlockAt(hiddenGrave.getBlockX(), hiddenGrave.getBlockY() - 2, hiddenGrave.getBlockZ());
            coffinBlock.setType(Material.BARREL);
            if (coffinBlock.getState() instanceof Barrel) {
                RuinedStructures999.plugin.addChest(coffinBlock.getLocation(), this.getName());
            }
        }
        this.buildCrypt(world, new Location(world, (double)(baseX - size / 2), (double)baseY, (double)(baseZ - size / 2)));
    }

    private void buildPerimeter(World world, int cx, int cy, int cz, int r) {
        for (int i = -r; i <= r; ++i) {
            if (this.rand.nextDouble() > 0.4) {
                world.getBlockAt(cx + i, cy, cz - r).setType(Material.STONE_BRICK_WALL);
            }
            if (this.rand.nextDouble() > 0.4) {
                world.getBlockAt(cx + i, cy, cz + r).setType(Material.STONE_BRICK_WALL);
            }
            if (this.rand.nextDouble() > 0.4) {
                world.getBlockAt(cx - r, cy, cz + i).setType(Material.STONE_BRICK_WALL);
            }
            if (!(this.rand.nextDouble() > 0.4)) continue;
            world.getBlockAt(cx + r, cy, cz + i).setType(Material.STONE_BRICK_WALL);
        }
    }

    private void buildGrave(World world, Location loc) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        Material mat = this.rand.nextBoolean() ? Material.STONE_BRICKS : Material.COBBLESTONE;
        int type = this.rand.nextInt(4);
        if (type == 0) {
            world.getBlockAt(x, y, z).setType(mat);
            world.getBlockAt(x, y + 1, z).setType(mat);
            world.getBlockAt(x + 1, y + 1, z).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(x - 1, y + 1, z).setType(Material.STONE_BRICK_WALL);
        } else if (type == 1) {
            world.getBlockAt(x, y - 1, z).setType(Material.COBBLESTONE_SLAB);
        } else if (type == 2) {
            world.getBlockAt(x, y, z).setType(Material.STONE_BRICK_STAIRS);
        } else {
            world.getBlockAt(x, y, z).setType(Material.STONE_BRICKS);
            world.getBlockAt(x, y + 1, z).setType(Material.STONE_BRICK_WALL);
        }
    }

    private void buildCrypt(World world, Location loc) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = -2; k < 3; ++k) {
                    if (!(this.rand.nextDouble() > 0.25)) continue;
                    if (i == 0 || i == 4 || j == 0 || j == 4) {
                        world.getBlockAt(x + i, y + k, z + j).setType(Material.MOSSY_STONE_BRICKS);
                        continue;
                    }
                    if (k != -2 && k != 2) continue;
                    world.getBlockAt(x + i, y + k, z + j).setType(Material.MOSSY_STONE_BRICK_SLAB);
                }
            }
        }
        Block spawnerBlock = world.getBlockAt(x + 2, y - 1, z + 2);
        spawnerBlock.setType(Material.SPAWNER);
        BlockState blockState = spawnerBlock.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(EntityType.SKELETON);
            spawner.update();
        }
        Block chestBlock = world.getBlockAt(x + 1, y - 1, z + 2);
        chestBlock.setType(Material.CHEST);
        if (chestBlock.getState() instanceof Chest) {
            RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
        }
    }

    private boolean isFlatEnough(Location loc, int radius, int maxHeightDiff) {
        World world = loc.getWorld();
        int y = loc.getBlockY();
        int checks = 0;
        int flat = 0;
        for (int x = -radius; x <= radius; x += 4) {
            for (int z = -radius; z <= radius; z += 4) {
                ++checks;
                if (Math.abs(world.getHighestBlockYAt(loc.getBlockX() + x, loc.getBlockZ() + z) - y) > maxHeightDiff) continue;
                ++flat;
            }
        }
        return (double)flat / (double)checks > 0.7;
    }
}

