/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class LootHandler
implements Listener {
    private final RuinedStructures999 plugin;
    private final Random random = new Random();

    public LootHandler(RuinedStructures999 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getInventory().getHolder() instanceof Chest) && !(event.getInventory().getHolder() instanceof Barrel)) {
            return;
        }
        Block block = event.getInventory().getLocation().getBlock();
        Location loc = block.getLocation();
        String structureType = this.plugin.getStructureTypeForChest(loc);
        if (structureType == null || this.plugin.isChestLooted(loc)) {
            return;
        }
        if (!event.getInventory().isEmpty()) {
            return;
        }
        this.fillChest(event.getInventory(), structureType);
        this.plugin.markChestAsLooted(loc);
        this.plugin.getLogger().info("Filled container for structure '" + structureType + "' at " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ());
    }

    private void fillChest(Inventory inventory, String structureType) {
        inventory.clear();
        Map<ItemStack, Integer> lootPool = this.getLootPool(structureType);
        int itemsToPlace = 3 + this.random.nextInt(3);
        for (int i = 0; i < itemsToPlace; ++i) {
            ItemStack item;
            int slot = this.random.nextInt(inventory.getSize());
            for (int attempts = 0; inventory.getItem(slot) != null && attempts < 100; ++attempts) {
                slot = this.random.nextInt(inventory.getSize());
            }
            if (inventory.getItem(slot) != null || (item = this.getRandomItemFromPool(lootPool)) == null) continue;
            inventory.setItem(slot, item);
        }
    }

    private Map<ItemStack, Integer> getLootPool(String structureType) {
        HashMap<ItemStack, Integer> pool = new HashMap<ItemStack, Integer>();
        if ("piglin_village".equals(structureType)) {
            pool.put(new ItemStack(Material.GOLD_INGOT, 2 + this.random.nextInt(4)), 20);
            pool.put(new ItemStack(Material.GILDED_BLACKSTONE, 2 + this.random.nextInt(3)), 15);
            pool.put(new ItemStack(Material.PORKCHOP, 2 + this.random.nextInt(3)), 10);
            pool.put(new ItemStack(Material.LEATHER, 2 + this.random.nextInt(3)), 10);
            pool.put(new ItemStack(Material.NETHER_WART, 1 + this.random.nextInt(3)), 5);
            pool.put(new ItemStack(Material.GOLDEN_SWORD), 5);
            pool.put(new ItemStack(Material.CROSSBOW), 5);
            pool.put(new ItemStack(Material.GOLD_NUGGET, 3 + this.random.nextInt(6)), 10);
            pool.put(new ItemStack(Material.SOUL_SAND, 1 + this.random.nextInt(4)), 5);
            pool.put(this.createEnchantedBook(Enchantment.SOUL_SPEED, 1), 2);
            pool.put(this.createEnchantedBook(Enchantment.QUICK_CHARGE, 1), 2);
        } else if ("collapsed_watchtower".equals(structureType)) {
            pool.put(new ItemStack(Material.ARROW, 7 + this.random.nextInt(13)), 20);
            pool.put(new ItemStack(Material.BOW), 10);
            pool.put(new ItemStack(Material.IRON_INGOT, 2 + this.random.nextInt(3)), 15);
            pool.put(new ItemStack(Material.COBBLESTONE, 8 + this.random.nextInt(13)), 10);
            pool.put(new ItemStack(Material.ROTTEN_FLESH, 2 + this.random.nextInt(4)), 5);
            pool.put(new ItemStack(Material.SPYGLASS), 5);
            pool.put(new ItemStack(Material.STONE_SWORD), 10);
            pool.put(new ItemStack(Material.LEATHER_HELMET), 5);
            pool.put(new ItemStack(Material.LEATHER_CHESTPLATE), 5);
            pool.put(new ItemStack(Material.BONE, 2 + this.random.nextInt(4)), 5);
            pool.put(this.createEnchantedBook(Enchantment.POWER, 1), 2);
            pool.put(this.createEnchantedBook(Enchantment.PROTECTION, 1), 2);
        } else if ("ruined_house".equals(structureType)) {
            pool.put(new ItemStack(Material.BREAD, 2 + this.random.nextInt(3)), 20);
            pool.put(new ItemStack(Material.WOODEN_SWORD), 10);
            pool.put(new ItemStack(Material.COAL, 2 + this.random.nextInt(5)), 15);
            pool.put(new ItemStack(Material.STICK, 3 + this.random.nextInt(6)), 10);
            pool.put(new ItemStack(Material.WOODEN_AXE), 5);
            pool.put(new ItemStack(Material.WOODEN_PICKAXE), 5);
            pool.put(new ItemStack(Material.APPLE), 10);
            pool.put(new ItemStack(Material.BOOK), 5);
            pool.put(new ItemStack(Material.WHEAT_SEEDS, 2 + this.random.nextInt(4)), 5);
            pool.put(this.createEnchantedBook(Enchantment.EFFICIENCY, 1), 2);
            pool.put(this.createEnchantedBook(Enchantment.UNBREAKING, 1), 2);
        } else if ("sunken_shrine".equals(structureType)) {
            pool.put(new ItemStack(Material.FISHING_ROD), 15);
            pool.put(new ItemStack(Material.COD, 2 + this.random.nextInt(3)), 20);
            pool.put(new ItemStack(Material.SALMON, 2 + this.random.nextInt(3)), 20);
            pool.put(new ItemStack(Material.NAUTILUS_SHELL), 5);
            pool.put(new ItemStack(Material.HEART_OF_THE_SEA), 1);
            pool.put(new ItemStack(Material.PRISMARINE_SHARD, 1 + this.random.nextInt(4)), 10);
            pool.put(new ItemStack(Material.PRISMARINE_CRYSTALS, 1 + this.random.nextInt(3)), 10);
            pool.put(this.createEnchantedBook(Enchantment.LURE, 1), 2);
            pool.put(this.createEnchantedBook(Enchantment.LUCK_OF_THE_SEA, 1), 2);
        } else if ("bandit_camp".equals(structureType)) {
            pool.put(new ItemStack(Material.CROSSBOW), 15);
            pool.put(new ItemStack(Material.ARROW, 10 + this.random.nextInt(10)), 20);
            pool.put(new ItemStack(Material.EMERALD, 1 + this.random.nextInt(2)), 10);
            pool.put(new ItemStack(Material.BREAD, 2 + this.random.nextInt(3)), 15);
            pool.put(new ItemStack(Material.COOKED_BEEF, 1 + this.random.nextInt(2)), 10);
            pool.put(new ItemStack(Material.IRON_INGOT, 1 + this.random.nextInt(3)), 5);
            pool.put(new ItemStack(Material.GOLD_NUGGET, 2 + this.random.nextInt(5)), 5);
        } else if ("pillager_castle".equals(structureType)) {
            pool.put(new ItemStack(Material.IRON_HELMET), 5);
            pool.put(new ItemStack(Material.IRON_CHESTPLATE), 5);
            pool.put(new ItemStack(Material.IRON_LEGGINGS), 5);
            pool.put(new ItemStack(Material.IRON_BOOTS), 5);
            pool.put(new ItemStack(Material.IRON_SWORD), 10);
            pool.put(new ItemStack(Material.IRON_AXE), 10);
            pool.put(new ItemStack(Material.CROSSBOW), 15);
            pool.put(this.createEnchantedBook(Enchantment.QUICK_CHARGE, 2), 2);
            pool.put(this.createEnchantedBook(Enchantment.MULTISHOT, 1), 1);
            pool.put(new ItemStack(Material.EMERALD, 3 + this.random.nextInt(5)), 20);
            pool.put(new ItemStack(Material.BREAD, 5 + this.random.nextInt(6)), 20);
            pool.put(new ItemStack(Material.TOTEM_OF_UNDYING), 1);
        } else if ("abandoned_quarry".equals(structureType)) {
            pool.put(new ItemStack(Material.COAL, 5 + this.random.nextInt(10)), 25);
            pool.put(new ItemStack(Material.RAW_IRON, 3 + this.random.nextInt(5)), 20);
            pool.put(new ItemStack(Material.RAW_COPPER, 3 + this.random.nextInt(5)), 15);
            pool.put(new ItemStack(Material.COBBLESTONE, 10 + this.random.nextInt(20)), 10);
            pool.put(new ItemStack(Material.BREAD, 2 + this.random.nextInt(3)), 15);
            pool.put(new ItemStack(Material.STONE_PICKAXE), 10);
            ItemStack enchantedPick = new ItemStack(Material.IRON_PICKAXE);
            enchantedPick.addEnchantment(Enchantment.EFFICIENCY, 2);
            pool.put(enchantedPick, 2);
        } else if ("haunted_graveyard".equals(structureType)) {
            pool.put(new ItemStack(Material.BONE, 3 + this.random.nextInt(6)), 25);
            pool.put(new ItemStack(Material.ROTTEN_FLESH, 2 + this.random.nextInt(5)), 20);
            pool.put(new ItemStack(Material.POISONOUS_POTATO), 10);
            pool.put(new ItemStack(Material.SKELETON_SKULL), 1);
            pool.put(this.createEnchantedBook(Enchantment.BINDING_CURSE, 1), 5);
            pool.put(new ItemStack(Material.IRON_INGOT, 1 + this.random.nextInt(2)), 10);
        } else if ("sunken_graveyard".equals(structureType)) {
            pool.put(new ItemStack(Material.PRISMARINE_SHARD, 2 + this.random.nextInt(4)), 20);
            pool.put(new ItemStack(Material.NAUTILUS_SHELL), 10);
            pool.put(new ItemStack(Material.GOLD_NUGGET, 4 + this.random.nextInt(7)), 15);
            pool.put(new ItemStack(Material.HEART_OF_THE_SEA), 1);
            ItemStack enchantedRod = new ItemStack(Material.FISHING_ROD);
            enchantedRod.addEnchantment(Enchantment.LUCK_OF_THE_SEA, 2);
            pool.put(enchantedRod, 5);
        }
        return pool;
    }

    private ItemStack getRandomItemFromPool(Map<ItemStack, Integer> pool) {
        int totalWeight = 0;
        for (int weight : pool.values()) {
            totalWeight += weight;
        }
        if (totalWeight <= 0) {
            return null;
        }
        int randomValue = this.random.nextInt(totalWeight);
        int currentWeight = 0;
        for (Map.Entry<ItemStack, Integer> entry : pool.entrySet()) {
            if (randomValue >= (currentWeight += entry.getValue().intValue())) continue;
            return entry.getKey().clone();
        }
        return null;
    }

    private ItemStack createEnchantedBook(Enchantment enchantment, int level) {
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
        meta.addStoredEnchant(enchantment, level, true);
        book.setItemMeta((ItemMeta)meta);
        return book;
    }
}

