/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.EntityType;

public class PillagerCastle
extends RuinedStructures999.Structure {
    private final Random rand = new Random();

    public PillagerCastle(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 5; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(-3);
            int highestY = world.getHighestBlockYAt(baseX + 10, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(-3)) + 10);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            Biome biome = world.getBlockAt(baseX + 10, highestY, baseZ + 10).getBiome();
            if (!this.getAllowedBiomes().isEmpty() && !this.getAllowedBiomes().contains(biome)) continue;
            return base;
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        this.buildFoundationAndFloor(base);
        this.buildCornerTower(new Location(world, (double)baseX, (double)baseY, (double)baseZ));
        this.buildCornerTower(new Location(world, (double)(baseX + 15), (double)baseY, (double)baseZ));
        this.buildCornerTower(new Location(world, (double)baseX, (double)baseY, (double)(baseZ + 15)));
        this.buildCornerTower(new Location(world, (double)(baseX + 15), (double)baseY, (double)(baseZ + 15)));
        this.buildWalls(base);
        this.buildCenterTower(new Location(world, (double)(baseX + 7), (double)baseY, (double)(baseZ + 7)));
    }

    private void buildFoundationAndFloor(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x = 0; x < 20; ++x) {
            for (int z = 0; z < 20; ++z) {
                boolean inCenterTower;
                world.getBlockAt(baseX + x, baseY - 1, baseZ + z).setType(Material.STONE_BRICKS);
                if (x <= 0 || x >= 19 || z <= 0 || z >= 19) continue;
                boolean inCornerTower = x < 5 && z < 5 || x > 14 && z < 5 || x < 5 && z > 14 || x > 14 && z > 14;
                boolean bl = inCenterTower = x >= 7 && x <= 11 && z >= 7 && z <= 11;
                if (inCornerTower || inCenterTower) continue;
                Material floorMat = this.rand.nextDouble() < 0.5 ? Material.DIORITE : Material.POLISHED_DIORITE;
                world.getBlockAt(baseX + x, baseY, baseZ + z).setType(floorMat);
            }
        }
    }

    private void buildCornerTower(Location loc) {
        int i;
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 10; ++k) {
                    if (i != 0 && i != 4 && j != 0 && j != 4) continue;
                    Material wallMat = this.rand.nextDouble() < 0.8 ? Material.STONE_BRICKS : (this.rand.nextDouble() < 0.5 ? Material.CRACKED_STONE_BRICKS : Material.MOSSY_STONE_BRICKS);
                    world.getBlockAt(x + i, y + k, z + j).setType(wallMat);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            if (i % 2 != 0) continue;
            world.getBlockAt(x + i, y + 10, z).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(x + i, y + 10, z + 4).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(x, y + 10, z + i).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(x + 4, y + 10, z + i).setType(Material.STONE_BRICK_WALL);
        }
        Block spawnerBlock = world.getBlockAt(x + 2, y, z + 2);
        spawnerBlock.setType(Material.SPAWNER);
        BlockState k = spawnerBlock.getState();
        if (k instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)k;
            spawner.setSpawnedType(EntityType.PILLAGER);
            spawner.update();
        }
        Block doorBlock = world.getBlockAt(x + 2, y, z + 4);
        doorBlock.setType(Material.DARK_OAK_DOOR);
        Door doorData = (Door)doorBlock.getBlockData();
        doorData.setFacing(BlockFace.SOUTH);
        doorData.setHalf(Bisected.Half.BOTTOM);
        doorBlock.setBlockData((BlockData)doorData);
        Block doorTopBlock = world.getBlockAt(x + 2, y + 1, z + 4);
        doorTopBlock.setType(Material.DARK_OAK_DOOR);
        Door doorTopData = (Door)doorTopBlock.getBlockData();
        doorTopData.setFacing(BlockFace.SOUTH);
        doorTopData.setHalf(Bisected.Half.TOP);
        doorTopBlock.setBlockData((BlockData)doorTopData);
        for (int i2 = 0; i2 < 10; ++i2) {
            world.getBlockAt(x + 1, y + i2, z + 1).setType(Material.LADDER);
        }
        Block chestBlock = world.getBlockAt(x + 3, y + 10, z + 3);
        chestBlock.setType(Material.CHEST);
        if (chestBlock.getState() instanceof Chest) {
            RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
        }
    }

    private void buildWalls(Location base) {
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (i < 5 || i > 14) continue;
                world.getBlockAt(baseX + i, baseY + j, baseZ).setType(Material.STONE_BRICKS);
                world.getBlockAt(baseX + i, baseY + j, baseZ + 19).setType(Material.STONE_BRICKS);
                world.getBlockAt(baseX, baseY + j, baseZ + i).setType(Material.STONE_BRICKS);
                world.getBlockAt(baseX + 19, baseY + j, baseZ + i).setType(Material.STONE_BRICKS);
            }
            if (i % 2 != 0) continue;
            world.getBlockAt(baseX + i, baseY + 7, baseZ).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(baseX + i, baseY + 7, baseZ + 19).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(baseX, baseY + 7, baseZ + i).setType(Material.STONE_BRICK_WALL);
            world.getBlockAt(baseX + 19, baseY + 7, baseZ + i).setType(Material.STONE_BRICK_WALL);
        }
    }

    private void buildCenterTower(Location loc) {
        int j;
        int i;
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                for (int k = 0; k < 12; ++k) {
                    if (i != 0 && i != 4 && j != 0 && j != 4) continue;
                    Material wallMat = this.rand.nextDouble() < 0.9 ? Material.STONE_BRICKS : Material.CRACKED_STONE_BRICKS;
                    world.getBlockAt(x + i, y + k, z + j).setType(wallMat);
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                world.getBlockAt(x + i, y, z + j).setType(Material.RED_CARPET);
            }
        }
        for (i = 0; i < 8; ++i) {
            Block chestBlock = world.getBlockAt(x + 1 + i % 2 * 2, y + 1, z + 1 + i / 2 * 1);
            chestBlock.setType(Material.CHEST);
            if (!(chestBlock.getState() instanceof Chest)) continue;
            RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
        }
        world.getBlockAt(x + 2, y, z).setType(Material.AIR);
        world.getBlockAt(x + 2, y + 1, z).setType(Material.AIR);
        world.getBlockAt(x, y, z + 2).setType(Material.AIR);
        world.getBlockAt(x, y + 1, z + 2).setType(Material.AIR);
        for (i = 0; i < 5; ++i) {
            for (int j2 = 0; j2 < 5; ++j2) {
                world.getBlockAt(x + i, y + 4, z + j2).setType(Material.DARK_OAK_PLANKS);
            }
        }
        world.getBlockAt(x + 2, y + 5, z + 2).setType(Material.ENCHANTING_TABLE);
        for (i = 0; i < 6; ++i) {
            world.getBlockAt(x + 1 + i % 2 * 2, y + 5, z + 1 + i / 2 * 1).setType(Material.BOOKSHELF);
        }
        for (i = 0; i < 5; ++i) {
            for (int j3 = 0; j3 < 5; ++j3) {
                world.getBlockAt(x + i, y + 8, z + j3).setType(Material.DARK_OAK_PLANKS);
            }
        }
        for (i = 0; i < 4; ++i) {
            Block spawnerBlock = world.getBlockAt(x + 1 + i % 2 * 2, y + 9, z + 1 + i / 2 * 2);
            spawnerBlock.setType(Material.SPAWNER);
            BlockState blockState = spawnerBlock.getState();
            if (!(blockState instanceof CreatureSpawner)) continue;
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(EntityType.PILLAGER);
            spawner.update();
        }
        for (i = 0; i < 4; ++i) {
            Block stairsBlock = world.getBlockAt(x + 4, y + 1 + i, z + 2);
            stairsBlock.setType(Material.STONE_BRICK_STAIRS);
            Stairs stairsData = (Stairs)stairsBlock.getBlockData();
            stairsData.setFacing(BlockFace.WEST);
            stairsBlock.setBlockData((BlockData)stairsData);
        }
        for (i = 0; i < 4; ++i) {
            Block stairsBlock = world.getBlockAt(x, y + 5 + i, z + 2);
            stairsBlock.setType(Material.STONE_BRICK_STAIRS);
            Stairs stairsData = (Stairs)stairsBlock.getBlockData();
            stairsData.setFacing(BlockFace.EAST);
            stairsBlock.setBlockData((BlockData)stairsData);
        }
        for (i = -1; i < 6; ++i) {
            for (int j4 = -1; j4 < 6; ++j4) {
                if (i == -1 || i == 5 || j4 == -1 || j4 == 5) {
                    world.getBlockAt(x + i, y + 12, z + j4).setType(Material.STONE_BRICK_STAIRS);
                    continue;
                }
                world.getBlockAt(x + i, y + 12, z + j4).setType(Material.STONE_BRICKS);
            }
        }
    }
}

