/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.RuinedStructures999;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;

public class RuinedHouse
extends RuinedStructures999.Structure {
    private final int width = 5;
    private final int length = 5;
    private final int height = 4;
    private final Random rand = new Random();

    public RuinedHouse(String name, double spawnChance, Set<Biome> allowedBiomes) {
        super(name, spawnChance, allowedBiomes);
    }

    @Override
    public Location findValidSpawnLocation(Chunk chunk) {
        World world = chunk.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return null;
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            int baseZ;
            int baseX = chunk.getX() * 16 + this.rand.nextInt(12);
            int highestY = world.getHighestBlockYAt(baseX + 2, (baseZ = chunk.getZ() * 16 + this.rand.nextInt(12)) + 2);
            if (highestY < 1) continue;
            Location base = new Location(world, (double)baseX, (double)highestY, (double)baseZ);
            Biome biome = world.getBlockAt(baseX + 2, highestY, baseZ + 2).getBiome();
            if (!this.getAllowedBiomes().isEmpty() && !this.getAllowedBiomes().contains(biome)) continue;
            return base;
        }
        return null;
    }

    @Override
    public void generate(Location base) {
        int i;
        int z;
        int x;
        World world = base.getWorld();
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        for (int x2 = 0; x2 < 5; ++x2) {
            for (int y = 0; y < 6; ++y) {
                for (int z2 = 0; z2 < 5; ++z2) {
                    world.getBlockAt(baseX + x2, baseY + y, baseZ + z2).setType(Material.AIR, false);
                }
            }
        }
        Location chestLocation = null;
        int chestX = baseX + 1 + this.rand.nextInt(3);
        int chestZ = baseZ + 1 + this.rand.nextInt(3);
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                Block block = world.getBlockAt(baseX + x, baseY - 1, baseZ + z);
                if (this.rand.nextDouble() < 0.1) {
                    block.setType(Material.DIRT);
                } else {
                    block.setType(this.rand.nextDouble() < 0.6 ? Material.COBBLESTONE : Material.OAK_PLANKS);
                }
                if (x != chestX - baseX || z != chestZ - baseZ) continue;
                block.setType(Material.OAK_SLAB, false);
                Slab slab = (Slab)block.getBlockData();
                slab.setType(Slab.Type.BOTTOM);
                block.setBlockData((BlockData)slab);
                chestLocation = new Location(world, (double)chestX, (double)(baseY - 2), (double)chestZ);
            }
        }
        for (int y = 0; y < 4; ++y) {
            for (int x3 = 0; x3 < 5; ++x3) {
                for (int z3 = 0; z3 < 5; ++z3) {
                    boolean isWall;
                    boolean isCorner = !(x3 != 0 && x3 != 4 || z3 != 0 && z3 != 4);
                    boolean bl = isWall = !isCorner && (x3 == 0 || x3 == 4 || z3 == 0 || z3 == 4);
                    if (isCorner) {
                        if (!(this.rand.nextDouble() > 0.3)) continue;
                        for (int i2 = 0; i2 < 3; ++i2) {
                            if (!(this.rand.nextDouble() > 0.2)) continue;
                            world.getBlockAt(baseX + x3, baseY + i2, baseZ + z3).setType(Material.OAK_LOG, false);
                        }
                        continue;
                    }
                    if (!isWall || !(this.rand.nextDouble() > 0.4)) continue;
                    Material wallMat = this.rand.nextDouble() < 0.7 ? Material.COBBLESTONE : Material.MOSSY_COBBLESTONE;
                    world.getBlockAt(baseX + x3, baseY + y, baseZ + z3).setType(wallMat, false);
                }
            }
        }
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                if (!(this.rand.nextDouble() < 0.35)) continue;
                world.getBlockAt(baseX + x, baseY + 4 - 1, baseZ + z).setType(Material.OAK_PLANKS);
            }
        }
        for (i = 0; i < 2 + this.rand.nextInt(3); ++i) {
            int cobwebZ;
            int cobwebY;
            int cobwebX = baseX + this.rand.nextInt(5);
            if (world.getBlockAt(cobwebX, cobwebY = baseY + this.rand.nextInt(4), cobwebZ = baseZ + this.rand.nextInt(5)).getType() != Material.AIR) continue;
            world.getBlockAt(cobwebX, cobwebY, cobwebZ).setType(Material.COBWEB, false);
        }
        for (i = 0; i < 5 + this.rand.nextInt(5); ++i) {
            int vineZ;
            int vineY;
            int vineX = baseX + this.rand.nextInt(5);
            if (!world.getBlockAt(vineX, vineY = baseY + this.rand.nextInt(4), vineZ = baseZ + this.rand.nextInt(5)).getType().isSolid()) continue;
            world.getBlockAt(vineX, vineY - 1, vineZ).setType(Material.VINE, false);
        }
        if (chestLocation != null) {
            Block chestBlock = world.getBlockAt(chestLocation);
            chestBlock.setType(Material.CHEST, false);
            if (chestBlock.getState() instanceof Chest) {
                RuinedStructures999.plugin.addChest(chestBlock.getLocation(), this.getName());
            }
        }
    }
}

