/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.ruinedstructures999;

import com.yourname.ruinedstructures999.AbandonedQuarry;
import com.yourname.ruinedstructures999.BanditCamp;
import com.yourname.ruinedstructures999.HauntedGraveyard;
import com.yourname.ruinedstructures999.LootHandler;
import com.yourname.ruinedstructures999.PiglinVillage;
import com.yourname.ruinedstructures999.PillagerCastle;
import com.yourname.ruinedstructures999.RuinedHouse;
import com.yourname.ruinedstructures999.StructureSpawningListener;
import com.yourname.ruinedstructures999.SunkenGraveyard;
import com.yourname.ruinedstructures999.SunkenShrine;
import com.yourname.ruinedstructures999.WatchTower;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RuinedStructures999
extends JavaPlugin {
    public static RuinedStructures999 plugin;
    private final Map<String, Structure> structures = new HashMap<String, Structure>();
    private FileConfiguration config;
    private final Map<Location, String> chestLocations = new HashMap<Location, String>();
    private final Set<Location> lootedChests = new HashSet<Location>();

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.registerStructures();
        this.getServer().getPluginManager().registerEvents((Listener)new StructureSpawningListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LootHandler(this), (Plugin)this);
        this.getLogger().info("RuinedStructures999 enabled with " + this.structures.size() + " structures.");
    }

    private void registerStructures() {
        if (this.config.getBoolean("structures.piglin_village.enabled", true)) {
            this.structures.put("piglin_village", new PiglinVillage("piglin_village", this.config.getDouble("structures.piglin_village.spawn-chance-per-chunk", 0.14), this.getBiomesFromConfig("structures.piglin_village.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.collapsed_watchtower.enabled", true)) {
            this.structures.put("collapsed_watchtower", new WatchTower("collapsed_watchtower", this.config.getDouble("structures.collapsed_watchtower.spawn-chance-per-chunk", 0.12), this.getBiomesFromConfig("structures.collapsed_watchtower.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.ruined_house.enabled", true)) {
            this.structures.put("ruined_house", new RuinedHouse("ruined_house", this.config.getDouble("structures.ruined_house.spawn-chance-per-chunk", 0.1), this.getBiomesFromConfig("structures.ruined_house.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.sunken_shrine.enabled", true)) {
            this.structures.put("sunken_shrine", new SunkenShrine("sunken_shrine", this.config.getDouble("structures.sunken_shrine.spawn-chance-per-chunk", 0.05), this.getBiomesFromConfig("structures.sunken_shrine.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.bandit_camp.enabled", true)) {
            this.structures.put("bandit_camp", new BanditCamp("bandit_camp", this.config.getDouble("structures.bandit_camp.spawn-chance-per-chunk", 0.08), this.getBiomesFromConfig("structures.bandit_camp.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.pillager_castle.enabled", true)) {
            this.structures.put("pillager_castle", new PillagerCastle("pillager_castle", this.config.getDouble("structures.pillager_castle.spawn-chance-per-chunk", 0.02), this.getBiomesFromConfig("structures.pillager_castle.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.abandoned_quarry.enabled", true)) {
            this.structures.put("abandoned_quarry", new AbandonedQuarry("abandoned_quarry", this.config.getDouble("structures.abandoned_quarry.spawn-chance-per-chunk", 0.04), this.getBiomesFromConfig("structures.abandoned_quarry.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.haunted_graveyard.enabled", true)) {
            this.structures.put("haunted_graveyard", new HauntedGraveyard("haunted_graveyard", this.config.getDouble("structures.haunted_graveyard.spawn-chance-per-chunk", 0.05), this.getBiomesFromConfig("structures.haunted_graveyard.allowed-biomes")));
        }
        if (this.config.getBoolean("structures.sunken_graveyard.enabled", true)) {
            this.structures.put("sunken_graveyard", new SunkenGraveyard("sunken_graveyard", this.config.getDouble("structures.sunken_graveyard.spawn-chance-per-chunk", 0.06), this.getBiomesFromConfig("structures.sunken_graveyard.allowed-biomes")));
        }
    }

    private Set<Biome> getBiomesFromConfig(String path) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        List list = this.config.getStringList(path);
        for (String s : list) {
            try {
                biomes.add(Biome.valueOf((String)s.toUpperCase()));
            }
            catch (Exception exception) {}
        }
        return biomes;
    }

    public Structure getStructure(String name) {
        return this.structures.get(name.toLowerCase());
    }

    public Map<String, Structure> getStructures() {
        return this.structures;
    }

    public void addChest(Location location, String structureType) {
        this.chestLocations.put(location, structureType);
    }

    public String getStructureTypeForChest(Location location) {
        return this.chestLocations.get(location);
    }

    public boolean isChestLooted(Location location) {
        return this.lootedChests.contains(location);
    }

    public void markChestAsLooted(Location location) {
        this.lootedChests.add(location);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("spawnstructure")) {
            if (!sender.hasPermission("ruinedstructures999.spawnstructure")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage("\u00a7eUsage: /spawnstructure <name>");
                return true;
            }
            String name = args[0].toLowerCase();
            Structure s = this.getStructure(name);
            if (s == null) {
                sender.sendMessage("\u00a7cStructure not found: " + name);
                return true;
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                Location loc = player.getLocation();
                s.generate(loc);
                sender.sendMessage("\u00a7aForce-spawned structure: " + s.getName() + " at your location.");
                this.getLogger().info("Force-spawned structure " + s.getName() + " at " + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ());
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("rs999") && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("ruinedstructures999.reload")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            this.reloadConfig();
            sender.sendMessage("\u00a7aRuinedStructures999 config reloaded.");
            return true;
        }
        return false;
    }

    public static abstract class Structure {
        private final String name;
        private final double spawnChance;
        private final Set<Biome> allowedBiomes;

        public Structure(String name, double spawnChance, Set<Biome> allowedBiomes) {
            this.name = name;
            this.spawnChance = spawnChance;
            this.allowedBiomes = allowedBiomes != null ? allowedBiomes : new HashSet();
        }

        public String getName() {
            return this.name;
        }

        public Set<Biome> getAllowedBiomes() {
            return this.allowedBiomes;
        }

        public double getSpawnChance() {
            return this.spawnChance;
        }

        public abstract Location findValidSpawnLocation(Chunk var1);

        public abstract void generate(Location var1);
    }
}

